<?php
/** 	
 *	Classe Archivable
 *
 *	Objet generique permettant d'enregistrer des données
 *	pouvant etre utilisées avec le systeme de persistance
 *	
 *	@version : 2.2
 *	@date : 2012
 *	@author : Selenith (https://selenith.madyweb.net)
 *	@license : GPLv3 (https://www.gnu.org/licenses/gpl-3.0.html)
 *	
 *------------------------
 *fonctions 
 *
 *	-Constructeur(type) : le parametre est optionnel
 * 		Prend en parametre le nom de l'objet a archiver
 * 	
 *	-getType()
 *		indique le nom de l'objet archivable
 *	
 *	-set(champ, valeur)
 *		Modifie la valeur du champ passé en paramètre
 *	
 * 	-get(champ)
 *		Renvoi la valeur du champ passé en paramètre
 *		
 *	-getAttributs()
 *		Fonction permettant de donner à l'archiviste la liste des attributs a archiver
 *	
 *	-setAttributs(attributs)
 *		Fonction permettant de donner à l'archivable la liste des attributs fournit par l'archiviste
 */
class Archivable implements ArrayAccess{
	
	protected $archivable_name;
	protected $attributs = array();

	// ---------- Functions for using this class like an array ----------
	public function offsetExists($offset) {
		return isset($this->attributs[$offset]);
	}

	public function offsetGet($offset) {
		return $this->attributs[$offset];
	}

	public function offsetSet($offset , $value) {
		$this->attributs[$offset] = $value;
	}

	public function offsetUnset($offset) {
		unset($this->attributs[$offset]);
	}
	// ---------- End of array functions ----------

	
	public function get_archivable_name(){
		return $this->archivable_name;
	}	
	
	public function __construct($archivable_name = false){		
		$this->archivable_name = $archivable_name;		
	}	
	
	public function setAttributs($attributs){		
		$this->attributs =  $attributs;
	}
	
	public function getAttributs(){
		return $this->attributs;
	}
	
	public function set($champ, $valeur){		
		$this->attributs[$champ] = $valeur;		
	}

	public function get($champ){	
		$valeur = null;		
		if(isset($this->attributs[$champ])){		
			$valeur = $this->attributs[$champ];
		}			
		return $valeur ;
	}
	
	
}

?>
