/*
* Auteur : Selenith
* Date : 2017
* Version : 2.0.1
* Licence : GPL v3
* Project URL: https://nunstick.selenith.net
* 
*/
#include <Keyboard.h>
#include <Wire.h>
#include <ArduinoNunchuk.h>


boolean cPressed = false;
boolean zPressed = false;
boolean upPressed = false;
boolean downPressed = false;
boolean leftPressed = false;
boolean rightPressed = false;
boolean zDirPressed = false;

short negTrigger = 100;
short posTrigger = 170;
short shakeTrigger = 950;

ArduinoNunchuk nunchuk = ArduinoNunchuk();


void setup()
{
  //Serial.begin(BAUDRATE);
  nunchuk.init();   //Initialiser la Nunchuck
  Keyboard.begin();
  
}

void loop()
{
   
  nunchuk.update();  //lecture des donnees
  
 
  
  if(nunchuk.zButton == 0 && zPressed){
    Keyboard.release(' ');
    zPressed = false;
  }
  
  if(nunchuk.zButton == 1 && !zPressed){
    Keyboard.press(' ');
    zPressed = true;
  }
  
  
  if(nunchuk.cButton == 0 && cPressed){
    Keyboard.release('e');
    cPressed = false;
  }
  
  if(nunchuk.cButton == 1 && !cPressed){
    Keyboard.press('e');
    cPressed = true;
  }
  
  //droite
  if(nunchuk.analogX > posTrigger && !rightPressed){
    Keyboard.press('d');
    rightPressed = true;
  }
  
  if(nunchuk.analogX < posTrigger && rightPressed){
    Keyboard.release('d');
    rightPressed = false;
  }
  
  
  
  //gauche
  if(nunchuk.analogX < negTrigger && !leftPressed){
    Keyboard.press('a');
    leftPressed = true;
  }
  
  if(nunchuk.analogX > negTrigger && leftPressed){
    Keyboard.release('a');
    leftPressed = false;
  }
  
  
  //haut
  if(nunchuk.analogY < posTrigger && upPressed){
    Keyboard.release('w');
    upPressed = false;
  }
  
  if(nunchuk.analogY > posTrigger && !upPressed){
    Keyboard.press('w');
    upPressed = true;
  }
  
  
  //bas
  if(nunchuk.analogY < negTrigger && !downPressed){
    Keyboard.press('s');
    downPressed = true;
  }
  
  if(nunchuk.analogY > negTrigger && downPressed){
    Keyboard.release('s');
    downPressed = false;
  }
  
  
   if(nunchuk.accelZ > shakeTrigger && !zDirPressed){
    Keyboard.press('r');
    zDirPressed = true;
  }
  
  if(nunchuk.accelZ < shakeTrigger && zDirPressed){
    Keyboard.release('r');
    zDirPressed = false;
  }
  

}
