<?php

include('../../../core/model/Archivable.php');
include('../../../core/model/Archiviste.php');
include('../../../core/model/Ribosome.php');
include('../../../core/model/Config.php');
include('../../auth/model/User.php');
include('../model/ProtoForumObject.php');
include('../model/Section.php');
include('../model/Fil.php');
include('../model/Post.php');
require_once ('../../../tools/htmlpurifier/library/HTMLPurifier.auto.php');


function ajoutSection(){
	$reponse = array('statut'=>'ok');	
	
	$nom = $_REQUEST['nom'];
	$desc = $_REQUEST['desc'];
	$ordre = $_REQUEST['ordre'];
		
	$arch = new Archiviste();
	$section = new Section() ;
	$section->set('nom', $nom);
	$section->set('description', $desc);
	$section->set('ordre', $ordre);
	
	$arch->archiver($section);
			
	return $reponse;	
}

function supprSection(){
	$reponse = array('statut'=>'ok');	
	
	$id = $_REQUEST['id'];
	
	$arch = new Archiviste();
	$section = new Section() ;
	$section->set('id', $id);
	
	//recherche des fils de la section
	$filType = new Fil();
	$filType->set('idSection', $id);
	
	$filsTrouve = $arch->restituer($filType);
	
	$postType = new Post();
	
	foreach($filsTrouve as $filTrouve){
		$postType->set('idFil', $filTrouve->get('id'));
		//recherche et suppresion des posts de la section
		$arch->supprimer($postType);
		
		
	}
	//suppression des fils
	$arch->supprimer($filType);
	
	//suppression de la section
	$arch->supprimer($section);
	
	
	
	return $reponse;
}

function getSection(){
	$reponse = array('statut'=>'ok');	
	
	$id = $_REQUEST['id'];
	
	$arch = new Archiviste();
	$section = new Section() ;
	$section->set('id', $id);
	
	$sections = $arch->restituer($section);
	$reponse['nom'] =$sections[0]->get('nom');
	$reponse['desc'] =$sections[0]->get('description');
	$reponse['ordre'] =$sections[0]->get('ordre');
	
	return $reponse;
}

function editSection(){
	$reponse = array('statut'=>'ok');	
	
	$id = $_REQUEST['id'];
	$nom = $_REQUEST['nom'];
	$desc = $_REQUEST['desc'];
	$ordre = $_REQUEST['ordre'];
	
	$arch = new Archiviste();
	$section = new Section() ;
	$section->set('id', $id);
	
	$newSection = new Section() ;
	$newSection->set('nom', $nom);
	$newSection->set('description', $desc);
	$newSection->set('ordre', $ordre);
	
	
	$sections = $arch->modifier($section, $newSection);	
	return $reponse;
}

function ajoutPost(){		
	
	$idFil = $_REQUEST['idFil'];
	$idSection = $_REQUEST['idSection'];
    $texte = $_REQUEST['texte'];
                	
	//$intrusion =  Securisator::checkIntrusion($texte);
	$config = HTMLPurifier_Config::createDefault();
    $purifier = new HTMLPurifier($config);
    $clean_html = $purifier->purify($texte);
	//if($intrusion){
	//	$reponse = array('statut'=>'intrusion');
		
	//}else{
		$reponse = array('statut'=>'ok');
		
		$arch = new Archiviste();
		$post = new post() ;
		
		
		date_default_timezone_set('Europe/Paris'); 
		$date = time ();
	
		
		$post->set('idUser', $_SESSION['id']);
		$post->set('texte', $clean_html);
		$post->set('idFil', $idFil);
		$post->set('date', $date);	
		
		$idPost = $arch->archiver($post);
		
		
		$fil = new Fil();
		$fil->set('id', $idFil);
		
		$filNew = new Fil();
		$filNew->set('idPost', $idPost);
		
		
		$arch->modifier($fil, $filNew);
		
		
		
		
		$section = new Section();
		$section->set('id', $idSection);
		
		$sectionNew = new Section();
		$sectionNew->set('idFil', $idFil);
		
		$arch->modifier($section, $sectionNew);
		
	//}
	
	
	
	return $reponse;
}


function editerPost(){
	$idPost = $_REQUEST['idPost'];
	$texte = $_REQUEST['texte'];

        $config = HTMLPurifier_Config::createDefault();
        $purifier = new HTMLPurifier($config);
        $clean_html = $purifier->purify($texte);	

        $reponse = array('statut'=>'ok');
		
	$arch = new Archiviste();
	$postAncien = new Post() ;
	$post = new Post() ;
	
	date_default_timezone_set('Europe/Paris'); 
	$date = time ();
	
	$droits = $_SESSION['droits'];
	
	
	if($droits == 'standard'){
		$idUser =  $_SESSION['id'];
		$postAncien->set('idUser', $idUser);
	}
	
	$postAncien->set('id', $idPost);
	$post->set('texte', $clean_html);
	$post->set('dateEdit', $date);	
	$post->set('edit', 'y');	
	
	$arch->modifier( $postAncien, $post);
	
	
	
	return $reponse;
}


function ajoutFil(){
    $idSection = $_REQUEST['idSection'];
    $texte = $_REQUEST['texte'];
    $titre = $_REQUEST['titre'];
	
	
    $config = HTMLPurifier_Config::createDefault();
    $purifier = new HTMLPurifier($config);
    $titre = $purifier->purify($titre);
	$texte = $purifier->purify($texte);
        	
    $reponse = array('statut'=>'ok');

    $arch = new Archiviste();
	$fil = new Fil() ;
	$fil->set('nom', $titre);
	$fil->set('idSection', $idSection);
	$fil->set('idUser', $_SESSION['id']);
		
		
	$idFil = $arch->archiver($fil);
	
	$post = new Post() ;
	date_default_timezone_set('Europe/Paris'); 
	$date = time ();	
		
	$post->set('idUser', $_SESSION['id']);
	$post->set('texte', $texte);
	$post->set('idFil', $idFil);
	$post->set('date', $date);	
		
	$idPost = $arch->archiver($post);
		
	$reponse['idFil']=$idFil;
		
	$fil = new Fil();
	$fil->set('id', $idFil);
		
		
	$filNew = new Fil();
	$filNew->set('idPost', $idPost);		
		
	$arch->modifier($fil, $filNew);
		
	$section = new Section();
	$section->set('id', $idSection);
		
	$sectionNew = new Section();
	$sectionNew->set('idFil', $idFil);
		
	$arch->modifier($section, $sectionNew);
		
	
	return $reponse;
}



function getPost(){
	$reponse = array('statut'=>'ok');	
	
	$id = $_REQUEST['idPost'];
	
	$arch = new Archiviste();
	$post = new Post() ;
	$post->set('id', $id);
	
	$posts = $arch->restituer($post);
	$reponse['texte'] =$posts[0]->get('texte');
	
	
	return $reponse;

}

/*
function majSign(){
	
	$reponse = array('statut'=>'ok');	
	$arch = new Archiviste();
	$userMAJ = new Archivable('User');
	
	$user = false;
	if(isset($_SESSION['id'])){
		$user = new Archivable('User');		
		$user->set('id', $_SESSION['id']);
		
		//ici on va recuperer les section dans la BDD
		$usersListe = $arch->restituer($user);
		
		if(count($usersListe) == 1){
			$userFound = $usersListe[0];
		}
	}
	
	if($user && isset($_REQUEST['signature'])){
	
	$texte = convertDataSent($_REQUEST['signature']);
	
	$intrusion =  Securisator::checkIntrusion($texte);
	
		if($intrusion){
			$reponse = array('statut'=>'intrusion');
			
		}else{
			
			$userMAJ->set('sign', $texte);	
			
			$arch->modifier($user, $userMAJ);
		
		}
	}else{
			$reponse['statut']='nok';
	}
	
	return $reponse;
}
*/

function listeMembres($droits){
	
	$reponse = array('statut'=>'ok', 'droits'=>$droits);	
	
	
	$user = new User();	
	
	$users = $user->listerUsers();
	$nbUsers = count($users);
	
	
	$reponse['users'] = array();
	for($i=0; $i<$nbUsers ; $i++){
		
		$reponse['users'][$i] = array();
		$reponse['users'][$i]['id'] = $users[$i]->get('id');
		$reponse['users'][$i]['nom'] = $users[$i]->get('login');
		
		$mail = $users[$i]->get('mail');
		if(isset($mail)&& $mail!=""){
			$reponse['users'][$i]['mail'] = "ok";
		}else{
			$reponse['users'][$i]['mail'] = "nada";
		}
		
	}		
	
	return $reponse;
}

function envoiMP($droits){
	
	$reponse = array('statut'=>'ok');
	
	$texte = $_REQUEST['texte'];
	$titre = $_REQUEST['titre'];

        $config = HTMLPurifier_Config::createDefault();
        $purifier = new HTMLPurifier($config);
        $titre = $purifier->purify($titre);
        $texte = $purifier->purify($texte);
	
        $idDestinataire = $_REQUEST['idDestinataire'];
	
	$arch = new Archiviste();
	
	$user = new User();
	
	if($idDestinataire != "tous"){
		$user->set('id', $idDestinataire);
	}
	
	
	
	$nom = $_SESSION['login'];
	$users = $arch->restituer($user);
	$site =Config::getVal('adresse');
	$siteName =Config::getVal('nom');
	
	
	$nbUsers = count($users);	
	
	for($i=0; $i<$nbUsers ; $i++){
		
		$mail = $users[$i]->get('mail');
		
		if(isset($mail)&& $mail!=""){
			
			$headers = 'Content-type: text/html; charset=UTF-8' . "\r\n"
							.'From: "'.$nom.' - '.$siteName.'"<'.$nom.'@'.$site.'>'."\r\n";
			mail ( $mail , $titre ,  $texte, $headers);
		}
		
	}	
	
	
	return $reponse;
}



function supprFil(){
	$reponse = array('statut'=>'ok');
	
	$idFil = $_REQUEST['idFil'];
	
	
	
	$arch = new Archiviste();
	
	$fil = new Fil();
	$post = new Post();
	
	
	$fil->set('id', $idFil);
	$post->set('idFil', $idFil);
	
	$arch->supprimer($fil);
	$arch->supprimer($post);
	
	return $reponse;

}

function modifTitreFil($modo){
	$reponse = array('statut'=>'ok');
	$texte = $_REQUEST['titre'];
	$idFil = $_REQUEST['idFil'];
	
        $config = HTMLPurifier_Config::createDefault();
        $purifier = new HTMLPurifier($config);
        $texte = $purifier->purify($texte);	
	
		
	$arch = new Archiviste();
	$fil = new Fil();
	$fil->set('id',$idFil);
	
	$fils = $arch->restituer($fil);
	if(count($fils)>0 && ($fils[0]->get('idUser') == $_SESSION['id'] || $modo)){
		$newTitre = new Fil();
		$newTitre->set('nom', $texte);
		
		$arch->modifier($fil, $newTitre);
	}else{
		$reponse = array('statut'=>'nok');
	}
		
	
	
	
	return $reponse;
}

function deplacerFil(){
	$reponse = array('statut'=>'ok');	
	$idFil = $_REQUEST['idFil'];
	$idNouvelleSec = $_REQUEST['idNouvelleSec'];
	$arch = new Archiviste();
	
	$testSection = new Section();
	$testSection->set('id', $idNouvelleSec);
	
	$blobSection = $arch->restituer($testSection);
	if(count($blobSection)==1){
		$filAncien = new Fil();
		$filAncien->set('id', $idFil);
		$filNouveau = new Fil();
		$filNouveau->set('idSection', $idNouvelleSec);
		$arch->modifier($filAncien, $filNouveau);
	}else{
		$reponse = array('statut'=>'nok');	
	}
	
	
	
	
	
	return $reponse;
}


//---------main----------------
session_start();

$droits = false;
if(isset($_SESSION['droits'])){
	$droits = $_SESSION['droits'];
}


$action=false;
if(isset($_REQUEST['action'])){
	$action = $_REQUEST['action'];
}



if($droits =='maitre' || $droits =='moderateur'){	
	
	if ($action == 'ajoutSection'){
		$reponse = ajoutSection();		
	}else if ($action == 'supprSection'){
		$reponse = supprSection();		
	}else if ($action == 'getSection'){
		$reponse = getSection();		
	}else if ($action == 'editSection'){
		$reponse = editSection();		
	}else if($action == 'ajoutPost'){
		$reponse = ajoutPost();		
	}else if($action == 'ajoutFil'){
		$reponse = ajoutFil();		
	}else if($action == 'editPost'){
		$reponse = editerPost();		
	}else if($action == 'getPost'){
		$reponse = getPost();
	}else if($action == 'listeMembres'){
		$reponse = listeMembres($droits);
	}else if($action == 'envoiMP'){
		$reponse = envoiMP($droits);
	}else if($action == 'supprFil'){
		$reponse = supprFil();
	}else if($action == 'modifTitreFil'){
		$reponse = modifTitreFil(true);
	}else if($action == 'deplacerFil'){
		$reponse = deplacerFil();
	}

}else if($droits =='standard' || $droits =='authentif'){

	if($action == 'ajoutPost'){
		$reponse = ajoutPost();				
	}else if($action == 'ajoutFil'){
		$reponse = ajoutFil();		
	}else if($action == 'editPost'){
		$reponse = editerPost();		
	}else if($action == 'getPost'){
		$reponse = getPost();
	}else if($action == 'listeMembres'){
		$reponse = listeMembres($droits);
	}else if($action == 'envoiMP' && $droits =='authentif'){
		$reponse = envoiMP($droits);
	}else if($action == 'modifTitreFil'){
		$reponse = modifTitreFil(false);
	}
	
}else{
	$reponse = array('statut'=>'deco');
}


echo(json_encode($reponse));

?>
