<?php
//importation des biblioteques
include('core/model/Securisator.php');
include('mods/auth/model/Auth.php');
include('mods/auth/model/User.php');
include('mods/site/config.php');
include('mods/forum/model/ProtoForumObject.php');
include('mods/forum/model/Post.php');
include('mods/forum/model/Fil.php');
include('mods/forum/model/Forum.php');
include('mods/forum/model/Section.php');
include('mods/forum/view/VueForum.php');
include('tools/htmlpurifier/library/HTMLPurifier.auto.php');


/**
Page d accueil du Forum

*/
function accueilForum(&$vueForum){
	
	$ariane = '
		<ol class="breadcrumb">
		  <li class="breadcrumb-item active">forum</li>
		</ol>' ;	
	$vueForum->addBodyContent('<input type="hidden" id="forumInfoPage" page="sections"  />');	
	
	//creation des objets qui vont contenir leur fonctions respectives
	$forum = new Forum();
        
	//liste des différntes section (tableau !!)
	$listeSection = $forum->listerSection();
	$vueForum->setBreadCrumb($ariane);
	$vueForum->accueilForum($listeSection);
	
}

function listeFils($idSection,&$vueForum){
	
	
	$forum = new Forum();
	//liste des différntes section (tableau !!)
	$listeFils = $forum->listerFils($idSection);
	
	$nbSection = count($listeFils);
	
	$section =$forum->getSection($idSection);
	
	$ariane = '
		<ol class="breadcrumb">
		  <li class="breadcrumb-item"><a href="/forum"> Forum </a></li>
		  <li class="breadcrumb-item active">'.$section->get('nom').'</li>
		</ol>' ;

	$vueForum->setBreadCrumb($ariane);
	$vueForum->addBodyContent('<input type="hidden" id="forumInfoPage" page="fils" idSection="'.$idSection.'" />');	
	$vueForum->listeFils($section, $listeFils);
}


function listePosts($idFil, $numPage, &$vueForum){
	
	$forum = new Forum();
	$auth = new Auth();
	
	
	//recuperation des infos pour le fil d'ariane
	$fil =$forum->getFil($idFil);
	$section =$forum->getSection($fil->get('idSection'));
	
	
	$ariane = '
		<ol class="breadcrumb">
		  <li class="breadcrumb-item"><a href="/forum"> Forum </a></li>
		  <li class="breadcrumb-item"><a href ="/forum/section/'.$section->get('id').'"> '.$section->get('nom').' </a></li>
		  <li class="breadcrumb-item active">'.$fil->get('nom').'</li>
		</ol>' ;

	
	
	$users = $auth->listerUsers();
	
	
	//liste des différentes section (tableau !!)
	$listePosts= $forum->listerPosts($idFil);
	
	$fil =$forum->getFil($idFil);
	
	$vueForum->setBreadCrumb($ariane);
	$vueForum->listePosts($listePosts, $section, $fil, $users, $numPage);
	
}


function pageProfil(&$vueForum){
   

	$auth = new Auth();
	
	
	
	$user = $auth->infoUser();
	
	$vueForum->pageProfil($user);
	
	
	
	 $ariane = '
		<ol class="breadcrumb">
		  <li class="breadcrumb-item"><a href="/forum"> Forum </a></li>
		  <li class="breadcrumb-item active">Profil</li>
		</ol>' ;
	$vueForum->setBreadCrumb($ariane);
}


function majProfil(&$vueForum){
	$auth = new Auth();
	$user = $auth->infoUser();	
	
	if($user){
		$traitementOk = true;
		$message='';

		$arch = new Archiviste();
		$userMAJ = new User();

			
		//recuperation de la requete
		
		$urlAvatar = '';
		$signature = '';
		
		$config = HTMLPurifier_Config::createDefault();		
                $purifier = new HTMLPurifier($config);

		if(isset($_REQUEST['urlAvatar'])){
                    $urlAvatar = $purifier->purify($_REQUEST['urlAvatar']);
		}
		
		if(isset($_REQUEST['signature'])){
                    $signature = $purifier->purify($_REQUEST['signature']);
		}
		
		
		if(isset($_REQUEST['notifMP'])){
			$userMAJ->set('notifMP', 'x');
		}else{
			$userMAJ->set('notifMP', 'n');
		}

				
		if($urlAvatar){
			$userMAJ->set('avatar', $urlAvatar);
		}

	
		if($signature){
			$userMAJ->set('sign', $signature);
		}
		
          
		$arch->modifier($user, $userMAJ); 
		
		$message = '<div class="alert alert-success" role="alert">Mise a jour effectuée.</div>';
	
		
		
		$ariane = '
		<ol class="breadcrumb">
		  <li class="breadcrumb-item"><a href="/forum"> Forum </a></li>
		  <li class="breadcrumb-item active">Profil</li>
		</ol>' ;
		$vueForum->setBreadCrumb($ariane);
	
		$user = $auth->infoUser();
		$vueForum->pageProfil($user, $message);
	}
	
}

function messagePrive($id, &$vueForum){	
	
	$ariane = '
		<ol class="breadcrumb">
		  <li class="breadcrumb-item"><a href="/forum"> Forum </a></li>
		  <li class="breadcrumb-item active">Message Privé</li>
		</ol>' ;

	$vueForum->setBreadCrumb($ariane);
	$vueForum->messagePrive($id);
	
	
	

}



//===================== MAIN =============================



include('core/controller/menu.php');

$titre = 'Forum';

$page =false;
$id =false;
$no =false;
if(isset($param[1]) && isset($param[2])){
	$page = $param[1];
	$id = $param[2];
}else if(isset($param[1])){
	$page = $param[1];
}

if(isset($param[3])){
	$no = $param[3];
}

session_start();
$auth = new Auth();
$authBundle = $auth->checkStatut();



$ariane = '';

$vueForum = new VueForum();
$vueForum->setSiteName($nomSite);



if($authBundle['statut']=='connect'){
	$vueForum->infoConnectForum($authBundle['statut'], $authBundle['droits'], $authBundle['id']);
   
}else{

	$vueForum->infoDecoForum();
}

if($page == 'section'){
	listeFils($id, $vueForum);
	
}else if($page == 'fil'){
	listePosts($id, $no, $vueForum);
	
}else if($page == 'mp'){
	messagePrive($id, $vueForum);
    
}else if($page == 'profil' && $authBundle['statut']=='connect'){
        pageProfil($vueForum);     
           
}else if($page == 'profil' && $authBundle['statut']=='connect'){
        pageProfil($vueForum);     
           
}else if($page == 'majProfil' && $authBundle['statut']=='connect'){
		
		majProfil($vueForum);
		
		
}else{
	accueilForum($vueForum);
}

//mise en place du script lié au module de forum


$head	.= $vueForum->getHead();
$body	 = $vueForum->getBody();
$scripts.= $vueForum->getScript();

include($templatePath.'index.php');

?>
