<?php
class Forum{

	private $dbPath = 'mods/forum/data/';
	
	public function __construct(){
		
		if(preg_match("/controller/", $_SERVER['PHP_SELF'])){
			$this->dbPath = '../data/';
		}	
		
	}

	//cette fonction permet de lister les sections
	public function listerSection(){
	
		//creation des objets qui vont contenir leur fonctions respectives
		$arch = new Archiviste();
		$section = new Section();
		//ici on va recuperer les section dans la BDD
		$sectionListe = $arch->restituer($section);
		$sectionListe = $arch->trier($sectionListe,'ordre', true);
		
	
		//$nom= false;
		/*
		if(count($sectionListe)>0){
			$lastFil =$sectionListe[0];
		}*/
		
		$nbSection = count($sectionListe);
		
		for($i=0;$i<$nbSection;$i++){
		
			$lastFil = new Archivable('ForumFil');
			$lastFil->set('id', $sectionListe[$i]->get('idFil'));
			
			$filsFound = $arch->restituer($lastFil);
			
			if(count($filsFound) ==1){
			
				$sectionListe[$i]->set('nomFil', $filsFound[0]->get('nom'));
			
				$lastPost = new Post();
				$lastPost->set('id', $filsFound[0]->get('idPost'));				
				$postesFounds = $arch->restituer($lastPost);
				if(count($postesFounds)==1){
					
					$sectionListe[$i]->set('datePost', $postesFounds[0]->get('date'));
					
					$lastAuteur = new User();
					$lastAuteur->set('id', $postesFounds[0]->get('idUser'));
					
					$auteurFound = $arch->restituer($lastAuteur);
					
					if(count($auteurFound)==1){
						
						$sectionListe[$i]->set('loginAuteur',  $auteurFound[0]->get('login'));
					}else{
						
						$sectionListe[$i]->set('loginAuteur', 'rien');
					}
					
				}else{
					$sectionListe[$i]->set('datePost', 'rien');
					$sectionListe[$i]->set('loginAuteur', 'rien');
					
				}
			
			}else{
				$sectionListe[$i]->set('datePost', 'rien');
				$sectionListe[$i]->set('loginAuteur', 'rien');
				$sectionListe[$i]->set('nomFil', 'rien');
			
			}
			
		}
		
			
		
		return $sectionListe;
	}	
	
	function listerFils($idSection){
		
		$blob = array();
		
		//creation des objets qui vont contenir leur fonctions respectives
		$arch = new Archiviste();
		$fil = new Fil();		
		$fil->set('idSection', $idSection);
		//ici on va recuperer les section dans la BDD
		$filListe = $arch->restituer($fil);
		
		$listeLastPost = array();
		$listeLastAutor = array();
		
		$nbFils = count($filListe);
		for($i=0;$i<$nbFils;$i++){
		
			//recherche du dernier post du fil
			$lastPost = new Archivable('ForumPost');
			$lastPost->set('id', $filListe[$i]->get('idPost'));			
			$postesFounds = $arch->restituer($lastPost);			
			
			if(count($postesFounds)==1){
				
				$filListe[$i]->set('datePost', $postesFounds[0]->get('date'));
				
				$lastAuteur = new User();
				$lastAuteur->set('id', $postesFounds[0]->get('idUser'));
				
				$auteurFound = $arch->restituer($lastAuteur);
				
				if(count($auteurFound)==1){
					
					$filListe[$i]->set('loginAuteur',  $auteurFound[0]->get('login'));
				}else{
					
					$filListe[$i]->set('loginAuteur', 'rien');
				}
				
			}else{
				$filListe[$i]->set('datePost', 'rien');
				$filListe[$i]->set('loginAuteur', 'rien');
				
			}
			
			//recherche de l'auteur du fil
			
			$primAuteur = new User();
			$primAuteur->set('id', $filListe[$i]->get('idUser'));
			$primAuteurTrouve = $arch->restituer($primAuteur);
			
			if(count($primAuteurTrouve)==1){				
				$filListe[$i]->set('primAuteur', $primAuteurTrouve[0]->get('login'));			
			}else{
				$filListe[$i]->set('primAuteur', "rien");
				
			}
			
		}
		
		 $filListe = $arch->trier($filListe, 'datePost', false);
		
		return $filListe; 		
	}
	
	function listerPosts($idFil){
	
		//creation des objets qui vont contenir leur fonctions respectives
		$arch = new Archiviste();
		$post = new Post();		
		$post->set('idFil', $idFil);
		//ici on va recuperer les section dans la BDD
		$postsListe = $arch->restituer($post);
		
		$postsListe = $arch->trier($postsListe, 'date', true);
		
		return $postsListe;		
	}
	
	function getSection($idSection){
	
		$arch = new Archiviste();
		$section = new Section();		
		$section->set('id', $idSection);
		//ici on va recuperer les section dans la BDD
		$sections = $arch->restituer($section);
		//$nom= false;
		if(count($sections)>0){
			$section =$sections[0];
		}
		
		
		return $section;		
	}
	
	function getFil($idFil){
		$arch = new Archiviste();
		$fil = new Fil();		
		$fil->set('id', $idFil);
		//ici on va recuperer les fils dans la BDD
		$fils = $arch->restituer($fil);
		//$nom= false;
		$nbFils = count($fils);
		if($nbFils>0){
			$fil =$fils[0];
		}
		
		
		
		
		
		return $fil;		
	}
	
	public static function dateToTime($date, $heure){
		$time= false;
		$h = $m = '';
		
		$jma = explode("-", $date);
		$hm = explode(":", $heure);
		
		date_default_timezone_set('Europe/Paris'); 
		
		if(count($jma==3) && count($hm) == 2){
			
			if(strlen($jma[0])==4){
				$dateTemp = strptime($date, '%Y-%m-%d');
				
				
			}else if(strlen($jma[2])==4){
				$dateTemp = strptime($date, '%d-%m-%Y');
				
			}else{
				return $time;
			}
			
			
			$h = $hm[0];
			$m = $hm[1];
			
			
			$time = mktime($h, $m, 1, $dateTemp['tm_mon']+1, $dateTemp['tm_mday'], $dateTemp['tm_year']+1900);
		}
		
		
		
		return $time;
	}
	
	
	public static function timeToDate($timestamp){
		
		date_default_timezone_set('Europe/Paris'); 
		
		return date('d-m-Y \à H:i', $timestamp);
	}
	
	public static function timeToDay($timestamp){
		
		date_default_timezone_set('Europe/Paris'); 
		
		return date('Y-m-d', $timestamp);
	}
	
	public static function timeToHour($timestamp){
		
		date_default_timezone_set('Europe/Paris'); 
		
		return date('H:i', $timestamp);
	}
}

?>
