(function(window) {

    function Forum() {

        var ctrlForum = '/mods/forum/controller/jQueryForum.php';

        var ckeForumConfig = {

            height: "400px", //hauteur CKeditor
            toolbar:
            [
                { name: 'document', items: ['Source', '-', 'Save', 'NewPage', 'DocProps', 'Preview', 'Print', '-', 'Templates'] },
                { name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'PasteText', '-', 'Undo', 'Redo'] },
                { name: 'editing', items: ['Find', 'Replace', '-', 'SelectAll', '-', 'SpellChecker', 'Scayt'] },
                { name: 'tools', items: ['Maximize', 'ShowBlocks', '-', 'About'] },
                '/',
                { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'RemoveFormat'] },
                { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl'] },
                '/',
                { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize'] },
                { name: 'colors', items: ['TextColor', 'BGColor'] },
                { name: 'insert', items: ['Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe', 'Link', 'Unlink'] }
            ]
        };

        var sceditorConfig = {
            plugins: 'bbcode',
            style: '/tools/sceditor/minified/jquery.sceditor.default.min.css',
            width: '100%',
            height: '400px',
            resizeWidth : false
        }
        
        var editeurTexte = '';

        this.attr = new Array();

        this.start = function() {


            var droits = $('#forumInfoConnect').attr('droits');
            var statut = $('#forumInfoConnect').attr('statut');

            if (statut == 'connect') {
                etatConnect(droits);
            } else {
                etatDeco();
            }
        }

        function etatConnect(droits) {
            var page = $('#forumInfoPage').attr('page');
          
            if (droits == 'maitre' || droits == 'moderateur') {
                
                if (page == 'sections') {
                    optionsAdminSections();
                } else if (page == 'fils') {
                    optionAjoutSection();
                    optionEditSection();
                } else if (page == 'posts') {
                    optionAjoutPost();
                    optionEditionPost(droits);
                    afficherModifTitreFil(droits);
                } else if (page == 'profil') {

                    //triggerProfil();

                } else if (page == 'mp') {

                    triggerMP();

                }
            } else if (droits == 'standard' || droits == 'authentif') {

               
                if (page == 'fils') {
                    optionAjoutSection();
                } else if (page == 'posts') {
                    optionAjoutPost();
                    optionEditionPost(droits);
                    afficherModifTitreFil(droits);
                } else if (page == 'profil') {
                    
                } else if (page == 'mp') {

                    triggerMP();

                }
            }
            
            
            var htmlBarre = '[<a href="#" id="btListeMembre" class="lienText" >Membres</a>]'           
             +' - '
             +'[<a href="/auth/profil">Compte<a/>] '
             +' - '
             +'[<a href="/forum/profil">Profil<a/>] '
             +' - '
             +' [<a href="/auth/deconnexion">Deconnexion</a>]';


            $('#barreProfil').html(htmlBarre);
            $('#btListeMembre').click(afficheListeMembre);

        }

        function etatDeco() {

            var form = document.createElement("form");
            form.className = "form-inline";
            form.action = "/auth/connexion";
            form.method = "post";
            $('#barreProfil').append(form);

            var formGroup = document.createElement("div");
            formGroup.className = 'form-group';
            form.appendChild(formGroup);

            //login
            var champForm;
            champForm = document.createElement("label");
            champForm.className = 'sr-only';
            champForm.setAttribute('for', 'login');
            champForm.appendChild(document.createTextNode(" Login"));
            formGroup.appendChild(champForm);

            champForm = document.createElement("input");
            champForm.type = "text";
            champForm.name = "login";
            champForm.id = "login";
            champForm.className = 'form-control';
            champForm.setAttribute('placeholder', "Login");
            formGroup.appendChild(champForm);

            //espace
            form.appendChild(document.createTextNode(" "));


            //password
            formGroup = document.createElement("div");
            formGroup.className = 'form-group mx-sm-3';
            form.appendChild(formGroup);

            champForm = document.createElement("label");
            champForm.className = 'sr-only';
            champForm.setAttribute('for', 'pass');
            champForm.appendChild(document.createTextNode(" Password"));
            formGroup.appendChild(champForm);

            champForm = document.createElement("input");
            champForm.type = "password";
            champForm.id = "pass";
            champForm.name = "pass";
            champForm.className = 'form-control';
            champForm.setAttribute('placeholder', "Password");
            formGroup.appendChild(champForm);

            //espace
            form.appendChild(document.createTextNode(" "));


            //submit
            champForm = document.createElement("input");
            champForm.type = "submit";
            champForm.value = "Connexion";
            champForm.id = "envoi";
            champForm.className = "btn btn-primary";
            form.appendChild(champForm);



            var btCreationCompte = document.createElement("a");
            btCreationCompte.href = '/auth/creation';
            btCreationCompte.appendChild(document.createTextNode("s'enregistrer"));
            btCreationCompte.className = "btn btn-outline-primary mx-sm-3";
            form.appendChild(btCreationCompte);


        }

        function pageEnregistrement() {
            $("#contenerForum").empty();

            var div = document.createElement("div");
            $("#contenerForum").append(div);
            div.style.textAlign = "center";

            var champInfo = document.createElement("span");
            champInfo.id = "champInfoConnec";
            div.appendChild(champInfo);

            var form = document.createElement("form");


            form.appendChild(document.createTextNode("login : "));
            form.appendChild(document.createElement("br"));
            form.action = "javascript:void(0);";
            var champForm;
            champForm = document.createElement("input");
            champForm.type = "text";
            champForm.id = "newLogin";
            form.appendChild(champForm);

            form.appendChild(document.createElement("br"));
            form.appendChild(document.createTextNode(" Password : "));
            form.appendChild(document.createElement("br"));
            champForm = document.createElement("input");
            champForm.type = "password";
            champForm.id = "newPass";
            form.appendChild(champForm);

            form.appendChild(document.createElement("br"));
            form.appendChild(document.createTextNode(" Email : "));
            form.appendChild(document.createElement("br"));
            champForm = document.createElement("input");
            champForm.type = "text";
            champForm.id = "newMail";
            form.appendChild(champForm);

            form.appendChild(document.createElement("br"));
            champForm = document.createElement("input");
            champForm.type = "submit";
            champForm.value = "Enregistrement";
            form.appendChild(champForm);


            $(div).append(form);
            $(form).submit(enregistrement);


        }

        function afficheListeMembre() {


            $.get(ctrlForum, { action: 'listeMembres' }, function(data) {
                if (data.statut == 'ok') {

                    $("#conteneurPage").empty();

                    var breadCrumb = document.createElement('ol');
                    breadCrumb.className = 'breadcrumb';
                    $("#conteneurPage").append(breadCrumb);

                    var item = document.createElement('li');
                    breadCrumb.appendChild(item);

                    var lien = document.createElement('a');
                    lien.appendChild(document.createTextNode('Forum'));
                    lien.href = '/forum';
                    item.appendChild(lien);


                    item = document.createElement('li');
                    breadCrumb.appendChild(item);
                    item.appendChild(document.createTextNode('Liste des membres'));



                    var nbMembre = data.users.length;

                    var conteneurFofo = document.createElement('div');
                    conteneurFofo.className = "forum";

                    $("#conteneurPage").append(conteneurFofo);


                    var titre = document.createElement('div');
                    titre.className = "titreForum";
                    conteneurFofo.appendChild(titre);

                    titre.appendChild(document.createTextNode('Membres du site ('+nbMembre+')'));

                    var enveloppe;

                                      
                    
                    var table= document.createElement('table');
                    table.className='table table-bordered';
                    conteneurFofo.appendChild(table);                    
                    
                    var thead = document.createElement('thead');
                    table.appendChild(thead);
                    
                    var tr = document.createElement('tr');
                    thead.appendChild(tr);

                    var th = document.createElement('th');
                    tr.appendChild(th);              
                    th.appendChild(document.createTextNode('Membres'));
                    
                    th = document.createElement('th');
                    tr.appendChild(th);
                    th.appendChild(document.createTextNode('Message privé'));

                    var tbody = document.createElement('tbody');
                    table.appendChild(tbody);
                    
                    var td;
                    var lien;
                    var nbMembre = data.users.length;

                    for (var i = 0; i < nbMembre; i++) {
                        tr = document.createElement('tr');
                        tbody.appendChild(tr);

                        td = document.createElement('td');
                        td.appendChild(document.createTextNode(data.users[i].nom));
                        tr.appendChild(td);


                        if (data.users[i].mail != "nada") {

                            td = document.createElement('td');
                            tr.appendChild(td);

                            lien = document.createElement('a');
                            lien.href = "/forum/mp/" + data.users[i].id;
                            lien.setAttribute('aria-hidden', 'true');
                            lien.title = "Envoyer un message privé à " + data.users[i].nom;
                            lien.setAttribute('idUser', data.users[i].id);
                            td.appendChild(lien);
                            lien.appendChild(document.createTextNode('Ecrire un MP'));


                        } else {
                            td = document.createElement('td');
                            tr.appendChild(td);
                        }
                    }
                } else {
                    alert(data);
                }
            }, 'json');


        }

        function triggerMP() {
            $('#infoMP').empty();

            delete CKEDITOR.instances['champMessage'];
            CKEDITOR.replace('champMessage', ckeForumConfig);

            $('#btEnvoi').click(envoiMP);

        }

        function envoiMP() {
            var titre = $('#champTitre').val();
            var texte = CKEDITOR.instances.champMessage.getData();
            var idDestinataire = $('#forumInfoPage').attr("idDestinataire");


            $.post(ctrlForum, { action: 'envoiMP', titre: titre, texte: texte, idDestinataire: idDestinataire }, function(data) {
                if (data.statut == "ok") {
                    $('#formulaireMP').empty();
                    $('#formulaireMP').html('<div class="alert alert-success" role="alert"> Votre message a été envoyé avec succes.</div>');

                } else {
                    alert(data);
                }
            }, 'json');


        }


        

        function optionsAdminSections() {

            $('.adminPhase').show();
            $(".adminSection").each(function(i) {
                var idSection = $(this).attr('idSection');
                $('#caseAdmin' + idSection).html('<button class="btn btn-primary" id="editSection' + idSection + '" idSection="' + idSection + '" >Editer</button> <button  id="supprSection' + idSection + '" class="btn btn-primary" idSection="' + idSection + '" >Supprimer</button>');
                $('#supprSection' + idSection).click(function() { supprSection($(this).attr('idSection')); });
                $('#editSection' + idSection).click(function() { editSection($(this).attr('idSection')); });
            });

            $('#ajoutSection').html('<button class="btn btn-primary" id="newSection" type="submit" >Nouvelle Section</button> <br /><br />');

            $('#newSection').click(newSection);

            $('.supprSection').click(function() { supprSection($(this).attr('idSection')); });
            $('.editSection').click(function() { editSection($(this).attr('idSection')); });

        }

        function supprSection(id) {

            var ok = confirm('Voulez vous vraiment supprimer cette section ?');

            if (ok) {
                $.post(ctrlForum, { action: 'supprSection', id: id }, function(data) {
                    if (data.statut == "ok") {
                        window.location = '/forum';
                    }
                }, 'json');
            }

        }

        function editSection(id) {

            //recuperation des information exact de la section
            $.post(ctrlForum, { action: 'getSection', id: id }, function(data) {

                if (data.statut == 'ok') {
                    plasmide.sequence.forum.attr['editCase' + id] = $('#case' + id).html();
                    $('#case' + id).html('nom : <input id="nomSection' + id + '" type="text"> Description : <input id="descSection' + id + '" type="text"  /> Ordre : <input id="ordeSection' + id + '" type="text"  />');

                    $('#nomSection' + id).val(data.nom);
                    $('#descSection' + id).val(data.desc);
                    $('#ordeSection' + id).val(data.ordre);

                    $('#caseAdmin' + id).html('<button class="btn btn-primary" title="Valider" id="validEdit' + id + '" idSection="' + id + '">Valider</button><button class="btn btn-primary" id="annulEdit' + id + '" title="Annuler" idSection="' + id + '">Annuler</button>');

                    //validation de l'edition
                    $('#validEdit' + id).click(function() { validEditSection(id); });
                    //annulation de l'edition
                    $('#annulEdit' + id).click(function() {
                        var id = $(this).attr('idSection');
                        $('#case' + id).html(plasmide.sequence.forum.attr['editCase' + id]);
                        $('#caseAdmin' + id).html('<button class="btn btn-primary" id="editSection' + id + '" idSection="' + id + '" >Editer</button><button  id="supprSection' + id + '" class="btn btn-primary" idSection="' + id + '" >Supprimer</button>');
                        $('#supprSection' + id).click(function() { supprSection($(this).attr('idSection')); });
                        $('#editSection' + id).click(function() { editSection($(this).attr('idSection')); });
                    });
                }

            }, 'json');

        }

        function validEditSection(id) {
            var nom = $('#nomSection' + id).val();
            var desc = $('#descSection' + id).val();
            var ordre = $('#ordeSection' + id).val();
            $.post(ctrlForum, { action: 'editSection', id: id, ordre: ordre, nom: nom, desc: desc }, function(data) {
                if (data.statut == "ok") {
                    window.location = '/forum';
                }
            }, 'json');
        }

        function newSection() {


           
            $('#ajoutSection').empty();

            var form = document.createElement("form");
            form.className = "form-inline";
            form.id = 'validNewSection';
            //form.action = "?mod=auth&action=connexion";
            //form.method = "post";
            $('#ajoutSection').append(form);

            $(form).on("submit", function(event) {
                event.preventDefault();
                validNewSection();
                return false;
            });


            var champForm;
            var inputGroup;

            //Nom section
            inputGroup = document.createElement("div");
            inputGroup.className = 'input-group';
            form.appendChild(inputGroup);

            champForm = document.createElement("span");
            champForm.className = 'input-group-addon';
            champForm.id = "nomSection-addon";
            champForm.appendChild(document.createTextNode("Section"));
            inputGroup.appendChild(champForm);


            champForm = document.createElement("input");
            champForm.type = "text";
            champForm.name = "nomSection";
            champForm.id = "nomSection";
            champForm.className = 'form-control';
            champForm.setAttribute('placeholder', "Nom ");
            champForm.setAttribute('aria-describedby', "nomSection-addon");
            inputGroup.appendChild(champForm);

            //espace
            form.appendChild(document.createTextNode(" "));


            //Description
            inputGroup = document.createElement("div");
            inputGroup.className = 'input-group';
            form.appendChild(inputGroup);

            champForm = document.createElement("span");
            champForm.className = 'input-group-addon';
            champForm.id = "decription-addon";
            champForm.appendChild(document.createTextNode("Description"));
            inputGroup.appendChild(champForm);


            champForm = document.createElement("input");
            champForm.type = "text";
            champForm.name = "descSection";
            champForm.id = "descSection";
            champForm.className = 'form-control';
            champForm.setAttribute('placeholder', "Description");
            champForm.setAttribute('aria-describedby', "decription-addon");
            inputGroup.appendChild(champForm);

            //espace
            form.appendChild(document.createTextNode(" "));


            //Ordre
            inputGroup = document.createElement("div");
            inputGroup.className = 'input-group';
            form.appendChild(inputGroup);

            champForm = document.createElement("span");
            champForm.className = 'input-group-addon';
            champForm.id = "ordre-addon";
            champForm.appendChild(document.createTextNode("Ordre"));
            inputGroup.appendChild(champForm);


            champForm = document.createElement("input");
            champForm.type = "number";
            champForm.name = "ordeSection";
            champForm.id = "ordeSection";
            champForm.className = 'form-control';
            champForm.setAttribute('placeholder', "numero");
            champForm.setAttribute('aria-describedby', "ordre-addon");
            inputGroup.appendChild(champForm);

            //espace
            form.appendChild(document.createTextNode(" "));
           

            //annuler
            champForm = document.createElement("input");
            champForm.type = "button";
            champForm.value = "Annuler";
            champForm.id = "annulNewSection";
            champForm.className = "btn btn-primary";
            form.appendChild(champForm);
            
            
            //espace
            form.appendChild(document.createTextNode(" "));

            $(champForm).click(function() {
                $('#ajoutSection').html('<button class="btn btn-primary" id="newSection" type="submit" >Nouvelle Section</button> <br /><br />');

                $('#newSection').click(newSection);
            });
            
            
             //submit
            champForm = document.createElement("input");
            champForm.type = "submit";
            champForm.value = "Valider";
            champForm.className = "btn btn-primary";
            form.appendChild(champForm);
            
             form.appendChild(document.createElement('br'));
             form.appendChild(document.createElement('br'));
        }

        function validNewSection() {
            var nom = $('#nomSection').val();
            var desc = $('#descSection').val();
            var ordre = $('#ordeSection').val();

            $.post(ctrlForum, { action: 'ajoutSection', nom: nom, desc: desc, ordre: ordre }, function(data) {
                if (data.statut == "ok") {
                    window.location = '/forum';
                }
            }, 'json');
        }



        //-----------------------gestion des fils de discution---------------------------------

        function optionAjoutSection() {
            var bouton = document.createElement('button');
            bouton.className = 'btn btn-primary';
            bouton.appendChild(document.createTextNode('Nouveau fil'));

            $('#optionsSectionForum').append(bouton);
            $('#optionsSectionForum').append(document.createElement('br'));
             $('#optionsSectionForum').append(document.createElement('br'));
            $(bouton).click(ajouterFil);


        }

        function optionEditSection() {
            var th = document.createElement('th');
            th.appendChild(document.createTextNode('Options'));
            $("#headTabFil").append(th);

            $('.infosFil').each(function() {
                var id = $(this).attr("idFil");
                var td = document.createElement('td');
                td.className='text-center';
                $(this).append(td);




                var btVerrou = document.createElement('button');
                btVerrou.className = 'btn btn-primary';

                var textVerrou = document.createTextNode('Verrouillage');
                btVerrou.appendChild(textVerrou);

                var btSuppr = document.createElement('button');
                btSuppr.className = 'btn btn-primary';

                btSuppr.setAttribute('idFil', id);
                var textSuppr = document.createTextNode('Suppression');
                btSuppr.appendChild(textSuppr);

                var btDepl = document.createElement('button');
                btDepl.className = 'btn btn-primary';

                btDepl.setAttribute('idFil', id);
                var textDepl = document.createTextNode('Deplacement');
                btDepl.appendChild(textDepl);

                var btnGroup = document.createElement('div');
                btnGroup.className = "btn-group";
                btnGroup.setAttribute('role', 'group');


                td.appendChild(btnGroup);

                //btnGroup.appendChild(btVerrou);
                btnGroup.appendChild(btSuppr);
                btnGroup.appendChild(btDepl);

                $(btSuppr).click(supprimerFil);
                //$(btVerrou).click(aImplementer);
                $(btDepl).click(deplacerFil);
            });



        }

        function deplacerFil() {
            var idFil = $(this).attr('idFil');

            var idNouvelleSec = prompt("Indiquez l'id de la nouvelle section");

            if (idNouvelleSec != "") {
                $.post(ctrlForum, { action: 'deplacerFil', idFil: idFil, idNouvelleSec: idNouvelleSec }, function(data) {

                    if (data.statut == "ok") {
                        window.location.reload();
                        //location.assign(location.href);
                    } else if (data.statut == "intrusion") {
                        alert('Toute tentative d\'intrusion est inutile. Passez votre chemin.');
                    } else if (data.statut == "deco") {
                        alert('Vous etes deconnecté, merci de vous reconnecter.');
                        location.assign(location.href);
                    } else if (data.statut == "nok") {
                        alert('Veuillez indiquer l\'ID d\'une section existante');
                    } else {
                        alert(data);
                    }
                }, 'json');

            }
        }

        function supprimerFil() {
            var idFil = $(this).attr('idFil');
            var supprOk = confirm('Voulez vous vraiment supprimer ce Fil ?');

            if (supprOk) {
                $.post(ctrlForum, { action: 'supprFil', idFil: idFil }, function(data) {

                    if (data.statut == "ok") {
                        window.location.reload();
                        //location.assign(location.href);
                    } else if (data.statut == "intrusion") {
                        alert('Toute tentative d\'intrusion est inutile. Passez votre chemin.');
                    } else if (data.statut == "deco") {
                        alert('Vous etes deconnecté, merci de vous reconnecter.');
                        window.location.reload();
                        //location.assign(location.href);
                    } else {
                        alert(data);
                    }
                }, 'json');
            }

        }


        function aImplementer() {
            alert('a implementer');
        }


        function ajouterFil() {

            $('#optionsSectionForum').empty();
            $('#zoneEditFil').empty();


            var form = document.createElement("form");
            form.className = "form-inline";
            form.id = 'validNewSection';
            $('#ajoutSection').append(form);

            $(form).on("submit", function(event) {
                event.preventDefault();
                validNewSection();
                return false;
            });

            var paragraphe = document.createElement('p');
            paragraphe.className ='text-center',
            $(paragraphe).append(document.createTextNode('Titre : '))
            $('#zoneEditFil').append(paragraphe);

            var champTitre = document.createElement('input');
            $(champTitre).attr("type", "text");
            $(champTitre).attr("id", "titreFil");
            $(paragraphe).append(champTitre);



            //mise en place de l'editeur
            var editeur = document.createElement('div');
            editeur.id = "editeur";
            $('#zoneEditFil').append(editeur);

            delete CKEDITOR.instances['editeur'];
            CKEDITOR.replace('editeur', ckeForumConfig);
            
            var div = document.createElement('div');
            div.className='text-center';
            $('#zoneEditFil').append(div);
             
             
            
            //mide en place du bouton annuler
            var btnBack = document.createElement('button');
            btnBack.className = 'btn btn-primary';
            btnBack.appendChild(document.createTextNode('Annuler'));
            $(div).append(btnBack);

            //space
            $(div).append(document.createTextNode(' '));

            //mise en place du bouton d'envoi
            var btnSend = document.createElement('button');
            btnSend.className = 'btn btn-primary';
            btnSend.appendChild(document.createTextNode('Envoyer'));
            $(div).append(btnSend);


            //mise en place des evenements
            $(btnSend).click(validerAjoutFil);
            $(btnBack).click(function() {
                window.location.reload();
            });
        }


        function validerAjoutFil() {
            var texte = CKEDITOR.instances.editeur.getData();
            var titre = $('#titreFil').val();
            if (titre != '') {

                var idSection = $('#forumInfoPage').attr("idSection");



                $.post(ctrlForum, { action: 'ajoutFil', titre: titre, idSection: idSection, texte: texte }, function(data) {
                    if (data.statut == "ok") {
                        var idFil = data.idFil;
                        window.location = '/forum/fil/' + idFil;
                    } else if (data.statut == "intrusion") {
                        alert('Toute tentative d\'intrusion est inutile. Passez votre chemin.');
                    }
                }, 'json');

            } else {
                alert('Merci de renseigner le titre du nouveau Fil.');

            }



        }

        //-------------------------------gestion des posts-----------------------------
        function optionAjoutPost() {

            $('#zoneEditPost').empty();
            var bouton = document.createElement('button');
            bouton.className = 'btn btn-primary';
            var text = document.createTextNode('Nouveau post');
            bouton.appendChild(text);

            $('#zoneEditPost').append(bouton);
            $('#zoneEditPost').append(document.createElement('br'));
            $('#zoneEditPost').append(document.createElement('br'));
            

            //ajout des evenements
            $(bouton).click(ajouterPost);

        }

        function ajouterPost() {
            $('.zoneEditPostUnique').each(function() {
                $(this).empty();
            });
            $('#zoneEditPost').empty();

            //mise en place de l'editeur
            var editeur = document.createElement('textarea');
            editeur.id = "editeur";
            $('#zoneEditPost').append(editeur);

            
            //$('#editeur').sceditor(sceditorConfig);
            delete CKEDITOR.instances['editeur'];
            CKEDITOR.replace('editeur', ckeForumConfig);
            
            
            var div = document.createElement('div');
            div.className='text-center';
            $('#zoneEditPost').append(div);
             
            //mise en place du bouton d'envoi
            var bouton = document.createElement('button');
            bouton.className = 'btn btn-primary';
            bouton.appendChild(document.createTextNode('Envoyer'));

            var annuler = document.createElement('button');
            annuler.className = 'btn btn-primary';
            annuler.appendChild(document.createTextNode('Annuler'));

            $(div).append(annuler);
            $(div).append(document.createTextNode(' '));            
            $(div).append(bouton);
            $(div).append(document.createElement('br'));
            $(div).append(document.createElement('br'));

            //mise en place des evenements
            $(bouton).click(validerAjoutPost)
            $(annuler).click(function() { optionAjoutPost(); });

        }

        function validerAjoutPost() {
            
            var texte = CKEDITOR.instances.editeur.getData();
            var idFil = $('#forumInfoPage').attr("idFil");
            var idSection = $('#forumInfoPage').attr("idSection");

            $.post(ctrlForum, { action: 'ajoutPost', idFil: idFil, idSection: idSection, texte: texte }, function(data) {

                if (data.statut == "ok") {
                    location.reload();
                }  else if (data.statut == "deco") {
                    alert('vous etes déconnecté. Rechargez la page et reconnectez vous.');
                    
                }else {
                    alert(data);
                }
            }, 'json');

        }

        function afficherModifTitreFil(droits) {
            var idUserCourant = $('#forumInfoConnect').attr('iduser');

            var idPrimAuteur = $('#forumInfoPage').attr('idauteur');

            if (idUserCourant == idPrimAuteur || droits == "maitre" || droits == 'moderateur') {
                var icon = document.createElement('span');
                icon.className = 'glyphicon glyphicon-edit';
                icon.setAttribute('aria-hidden', 'true');

                var bouton = document.createElement('button');
                bouton.className = 'btn btn-primary btn-sm btOptionForum';
                bouton.setAttribute('aria-label', 'Editer');
                bouton.appendChild(icon);
                bouton.appendChild(document.createTextNode(' Edit'));
                $('#btEditTitre').append(bouton);

                $(bouton).click(editerTitreFil);
            }

        }

        function editerTitreFil() {
            var nodeTitre = document.getElementById("titreForum");
            var titre = nodeTitre.getAttribute('var');
            var icon;


            plasmide.sequence.forum.attr.titreFil = titre;

            $(nodeTitre).empty();
             
            var form = document.createElement("form");
            form.className = "form-inline";
            $(nodeTitre).append(form);
            
            
            var input = document.createElement('input');
            input.id = 'champEditTitreFil';
            input.type = 'text';
            input.className='form-control';
            input.value = titre;
            form.appendChild(input);

            var ok = document.createElement('button');
            ok.className = 'btn btn-primary btn-sm';
            form.appendChild(ok);
            icon = document.createElement('span');
            icon.className = 'glyphicon glyphicon-ok';
            ok.appendChild(icon);


            var annuler = document.createElement('button');
            annuler.className = 'btn btn-primary btn-sm';
            annuler.setAttribute('title', 'Annuler');
            form.appendChild(annuler);
            icon = document.createElement('span');
            icon.className = 'glyphicon glyphicon-remove';
            annuler.appendChild(icon);


            $(form).on("submit", function(event) {
                event.preventDefault();
                valierEdtionTitreFil();
                return false;
            });
            
            $(ok).click(valierEdtionTitreFil);
            $(annuler).click(annulerEditionTitreFil);
        }

        function valierEdtionTitreFil() {



            var titre = $('#champEditTitreFil').val();
            var idFil = $('#forumInfoPage').attr("idfil");

            if (titre == "") {
                alert("Merci de ne pas laisser le champ titre vide.");
            } else {
                $.post(ctrlForum, { action: 'modifTitreFil', idFil: idFil, titre: titre }, function(data) {

                    if (data.statut == "ok") {
                        var nodeTitre = document.getElementById("titreForum");
                        $(nodeTitre).empty();
                        $(nodeTitre).attr('var', titre);

                        var titreZone = document.createElement('span');
                        titreZone.className = 'titreForum';
                        nodeTitre.appendChild(titreZone);


                        titreZone.appendChild(document.createTextNode(titre));

                        var bouton = document.createElement('span');
                        bouton.id = 'btEditTitre';
                        nodeTitre.appendChild(bouton);

                        afficherModifTitreFil($('#forumInfoConnect').attr('droits'));



                    } else if (data.statut == "deco") {
                        alert('Vous etes deconnecté, merci de vous reconnecter.');
                        window.location.reload();
                        //location.assign(location.href);
                    } else {
                        alert(data);
                    }
                }, 'json');
            }



        }


        function annulerEditionTitreFil() {
            var nodeTitre = document.getElementById("titreForum");
            $(nodeTitre).empty();
            var titre = document.createElement('span');
            titre.className = 'titreForum';
            nodeTitre.appendChild(titre);


            titre.appendChild(document.createTextNode(plasmide.sequence.forum.attr.titreFil));

            var bouton = document.createElement('span');
            bouton.id = 'btEditTitre';
            nodeTitre.appendChild(bouton);

            afficherModifTitreFil($('#forumInfoConnect').attr('droits'));
            

        }

        function optionEditionPost(droits) {


            var idUserCourant = $('#forumInfoConnect').attr('iduser');
            var btEditPost;
            $('.zoneOptionPost').each(function() {
                if ($(this).attr('idauteur') == idUserCourant || droits == "moderateur" || droits == "maitre") {
                    btEditPost = document.createElement('button');
                    btEditPost.className='btn btn-primary';
                    btEditPost.appendChild(document.createTextNode("Editer"));

                    var idPost = $(this).attr('idpost');

                    $(this).append(btEditPost);
                    $(btEditPost).click(function() { openEditPost(idPost); });
                }
            });
        }

        function openEditPost(idPost) {
            optionAjoutPost();
            var champEdition = '#editPost' + idPost;
            $('.zoneEditPostUnique').each(function() {
                $(this).empty();
            });




            //mise en place de l'editeur
            var editeur = document.createElement('div');
            editeur.id = "editeur";
            $(champEdition).append(editeur);

            var btnZone = document.createElement('div');
            btnZone.className='text-center';
            $(champEdition).append(btnZone);
            
            //mise en place du bouton d'envoi
            var bouton = document.createElement('button');
            bouton.className = 'btn btn-primary';
            bouton.appendChild(document.createTextNode('Envoyer'));

            var annuler = document.createElement('span');
            annuler.className = 'btn btn-primary';
            annuler.appendChild(document.createTextNode('Annuler'));
            
            $(btnZone).append(annuler);
            $(btnZone).append(document.createTextNode(' '));
            $(btnZone).append(bouton);
            



            //mise en place des evenements
            $(bouton).click(function() { modifierPost(idPost); });
            $(annuler).click(function() {

                if (editeurTexte) {
                    editeurTexte.destroy();
                    editeurTexte = null;
                }
                $(champEdition).empty();
            });


            //recuperation du text a editer
            $.post(ctrlForum, { action: 'getPost', idPost: idPost }, function(data) {

                if (data.statut == "ok") {
                    editeurTexte = CKEDITOR.appendTo('editeur', ckeForumConfig, data.texte);

                } else if (data.statut == "deco") {
                    alert('Vous etes deconnecté, merci de vous reconnecter.');
                } else {
                    alert(data);
                }
            }, 'json');


        }

        function modifierPost(idPost) {

            var texte = editeurTexte.getData();


            $.post(ctrlForum, { action: 'editPost', idPost: idPost, texte: texte }, function(data) {

                if (data.statut == "ok") {
                    
                    location.reload(true);
                } else if (data.statut == "deco") {
                    alert('Vous etes deconnecté, merci de vous reconnecter.');
                } else {
                    alert(data);
                }
            }, 'json');
        }

    }





    var forum = new Forum();
    plasmide.addSequence(forum, 'forum');
})(window);

