<?php
include('mods/site/config.php');
include('mods/auth/model/Auth.php');
include('mods/auth/model/User.php');
include('mods/raidplanner/view/VueAgenda.php');
include('mods/raidplanner/model/Agenda.php');
include('mods/raidplanner/model/ProtoRaidObject.php');
include('mods/raidplanner/model/Event.php');
include('mods/raidplanner/model/EventCom.php');
include('mods/raidplanner/model/EventInscrit.php');
include('tools/htmlpurifier/library/HTMLPurifier.auto.php');



include('core/controller/menu.php');


function voirEvent(&$vueAgenda, $id, $estModerateur, $idUser){
	
	
	if($id!==false){
		
		$editable = false;
		
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			
			$event = $events[0];
			
			if($estModerateur || $idUser == $event->get('idUser')){				
				$editable = true;
			}						
		
			
			//recuperation des inscriptions
			$inscription = new EventInscrit();
			$inscription->set('idEvent', $id);
			
			$inscriptions = $arch->restituer($inscription);
			
			$inscritSoiMeme = false;
			
			$userInscrit = new User();
			$usersFound;
			foreach($inscriptions as $inscripTMP){			
				
				$userInscrit->set('id', $inscripTMP->get('idUser'));
				
				$usersFound = $arch->restituer($userInscrit);
				$inscripTMP->set('login', $usersFound[0]->get('login'));
				
				if($inscripTMP->get('idUser') == $idUser){
					$inscritSoiMeme = $inscripTMP->get('etat');
				}
				
			}
			
			//recuperation des commentaires
			$comment = new EventCom();
			$comment->set('idEvent', $id);
			$comments = $arch->restituer($comment);
			$comments = $arch->trierNumCroissant($comments, 'date');
			$inscriptions = $arch->trier($inscriptions, 'login', true);
			
			$vueAgenda->ouvrirEvent($event, $editable, $inscriptions, $inscritSoiMeme, $comments);
		}
	}
	
}

function listeRaids(&$vueAgenda, $estAnimateur, $idUser){
		
	$arch = new Archiviste();
	$event = new Event();
	$inscritType = new EventInscrit();
	$inscrits;
	
	$nbDispo = 0;
	$nbValid = 0;
	
	
	$listeEvents =$arch->restituer($event);
	
	$eventsPertinents = array();
	
	$maintenant = time();
	
	foreach($listeEvents as $event){
		if(intval($event->get('date'))>$maintenant){
			$inscritType->set('idEvent', $event->get('id'));
						
			$inscrits = $arch->restituer($inscritType);
			
			$event->set('monEtat', 'n');
			
			foreach($inscrits as $inscrit){
				if($inscrit->get('etat')=='v'){
					$nbValid++;
				}else if($inscrit->get('etat')=='d'){
					$nbDispo++;
				}
				if($idUser == $inscrit->get('idUser')){
					$event->set('monEtat', $inscrit->get('etat'));
				}
			}
			$event->set('nbValid', $nbValid);
			$event->set('nbDispo', $nbDispo);
			$eventsPertinents[] = $event;
			
			$nbDispo = 0;
			$nbValid = 0;
		}		
	}	
	
	$eventsPertinents = $arch->trierNumCroissant($eventsPertinents, 'date');
	
	
	$vueAgenda->userPannel();
	if($estAnimateur){
		$vueAgenda->panneauCreerRaid();
	}
	
	$vueAgenda->listerRaid($eventsPertinents);
	
	
	$vueAgenda->panneauVoirRaidsAnciens();
	
	
}

function listeVieuxRaids(&$vueAgenda, $estAnimateur, $idUser){
	$arch = new Archiviste();
	$event = new Event();
	$inscritType = new EventInscrit();
	$inscrits;
	
	$nbDispo = 0;
	$nbValid = 0;
	
	
	
	$listeEvents =$arch->restituer($event);
	
	
	$eventsPertinents = array();
	
	$maintenant = time();
	
	foreach($listeEvents as $event){
		if(intval($event->get('date'))<$maintenant){
			$inscritType->set('idEvent', $event->get('id'));
						
			$inscrits = $arch->restituer($inscritType);
			
			$event->set('monEtat', 'n');
			
			foreach($inscrits as $inscrit){
				if($inscrit->get('etat')=='v'){
					$nbValid++;
				}else if($inscrit->get('etat')=='d'){
					$nbDispo++;
				}
				if($idUser == $inscrit->get('idUser')){
					$event->set('monEtat', $inscrit->get('etat'));
				}
			}
			$event->set('nbValid', $nbValid);
			$event->set('nbDispo', $nbDispo);
			$eventsPertinents[] = $event;
			
			$nbDispo = 0;
			$nbValid = 0;
		}		
	}	
	$eventsPertinents = $arch->trierNumDecroissant($eventsPertinents, 'date');
	$vueAgenda->listerRaid($eventsPertinents);
	
	// if($estAnimateur){
		// $vueAgenda->panneauCreerRaid();
	// }
	$vueAgenda->panneauVoirRaidsActuels();
}


function validEvent(&$vueAgenda, $idUser, $loginUser, $withMail=true){
	
	
	$nom = '';
	$date = '';
	$heure = '';
	$duree = '';
	$texte = '';
	
	if(isset($_POST['dureeEvent'])){
		$duree = htmlspecialchars($_POST['dureeEvent']);
	}
	
        $config = HTMLPurifier_Config::createDefault();
        $purifier = new HTMLPurifier($config);


	if(isset($_POST['textEvent'])){
		$texte = $purifier->purify($_POST['textEvent']);
	}
	
	if(isset($_POST['nomEvent']) && isset($_POST['dateEvent']) && isset($_POST['heureEvent'])){
		$nom = htmlspecialchars($_POST['nomEvent']);
		$date =  $_POST['dateEvent'];
		$heure = $_POST['heureEvent'];
		
		
		
		$timestamp = Agenda::dateToTime($date, $heure);
		
		if($timestamp){
			$arch = new Archiviste();		
			$event = new Event();
			
			
			
			$event->set('nom', $nom);
			$event->set('date', $timestamp);
			$event->set('duree', $duree);
			$event->set('texte', $texte);
			$event->set('idUser', $idUser);
			$event->set('nomLead', $loginUser);
			
			
			
			$idEvent = $arch->archiver($event);
			
			$vueAgenda->eventValidOk($idEvent, $timestamp);
			
			//envois des mail pour prevenir de l'ajout
			if($withMail){
				mailCreation($nom, $timestamp, $idEvent);
			}			
		}else{
			$vueAgenda->erreurValidEvent($nom, $duree, $date, $heure, $texte);
		}		
	}else{
		$vueAgenda->erreurValidEvent($nom, $duree, $date, $heure, $texte);
	}
	
}

function supprimerEvent(&$vueAgenda, $id, $estModerateur, $idUser){
	
	
	
	if($id!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			$eventF = $events[0];
			if($estModerateur || $idUser == $eventF->get('idUser')){				
				
				
				$inscrits = new EventInscrit();
				$inscrits->set('idEvent', $event->get('id'));
				
				$coms = new EventCom();
				$coms->set('idEvent', $event->get('id'));
				
				$arch->supprimer($inscrits);
				$arch->supprimer($coms);
				$arch->supprimer($event);
				
				$vueAgenda->pageSuppressionEvent();
			}			
		}
	}
}


function pageEditEvent(&$vueAgenda, $id){
	
        if($id!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			$event = $events[0];
			
			$vueAgenda->pageEditEvent($event);
		}
	}
}


function validEditEvent(&$vueAgenda, $id, $estModerateur, $idUser){
	
	if($id!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			$event = $events[0];
			if($estModerateur || $idUser == $event->get('idUser')){				
								
				$nom = '';
				$date = '';
				$heure = '';
				$duree = '';
				$texte = '';
			        
                                
                                $config = HTMLPurifier_Config::createDefault();
                                $purifier = new HTMLPurifier($config);
                                                                    	
				if(isset($_POST['dureeEvent'])){
					$duree = htmlspecialchars($_POST['dureeEvent']);
				}
				
				if(isset($_POST['textEvent'])){
					$texte = $purifier->purify($_POST['textEvent']);
				}

				if(isset($_POST['nomEvent']) && isset($_POST['dateEvent']) && isset($_POST['heureEvent'])){
					$nom = htmlspecialchars($_POST['nomEvent']);
					$date =  $_POST['dateEvent'];
					$heure = $_POST['heureEvent'];
					
					$timestamp = Agenda::dateToTime($date, $heure);
					if($timestamp){
						$arch = new Archiviste();		
						$newEvent = new Event();
						
						
						
						$newEvent->set('nom', $nom);
						$newEvent->set('date', $timestamp);
						$newEvent->set('duree', $duree);
						$newEvent->set('texte', $texte);
						
						
						
						
						$arch->modifier($event, $newEvent);
					
						$vueAgenda->pageEventEditOk($event);
					}else{
						$vueAgenda->erreurValidEvent($nom, $duree, $date, $heure, $texte);
					}				
				}else{
					$vueAgenda->erreurValidEvent($nom, $duree, $date, $heure, $texte);
				}
					
				
			}			
		}
	}
	
}

function inscriptionEvent(&$vueAgenda, $id, $idUser){
	
	$classe = '';
	
	
	if(isset($_POST['classe'])){
		$classe = htmlspecialchars($_POST['classe']);
	}
	
	if($id!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			
			$inscription = new EventInscrit();
			$inscription->set('idUser',$idUser);
			$inscription->set('idEvent',$id);	
			
			$inscritpions = $arch->restituer($inscription);
			
			if(count($inscritpions)==1){
				
				$modifInscript =  new EventInscrit();
				$modifInscript->set('etat','d');
				$modifInscript->set('classe',$classe);
				$arch->modifier($inscription, $modifInscript);
			}else{
				
				$inscription->set('classe',$classe);
				$inscription->set('etat','d');
				$arch->archiver($inscription);
			}
			
			
			
			
			$vueAgenda->pageinscriptionOk($id);
		}
	}
}

function pageInscription(&$vueAgenda, $id){

	
	if($id!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			
			$vueAgenda->pageInscription($id);
			
		}
	}
	
}

function absentEvent(&$vueAgenda, $id, $idUser){
	
	if($id!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$id);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			
			$inscription = new EventInscrit();
			$inscription->set('idUser',$idUser);
			$inscription->set('idEvent',$id);	
			
			$inscritpions = $arch->restituer($inscription);
			
			if(count($inscritpions)==1){
				
				$modifInscript =  new EventInscrit();
				$modifInscript->set('etat','a');
				$arch->modifier($inscription, $modifInscript);
			}else{
				
				
				$inscription->set('etat','a');
				$arch->archiver($inscription);
			}
						
			$vueAgenda->pageAbsentOk($id);
		}
	}
}

function changerEtatInscrit(&$vueAgenda, $idEvent, $estModerateur, $idInscrit, $idUser){
	
	
	
	
	
	if($idEvent!==false && $idInscrit!==false){
		$arch = new Archiviste();
		$event = new Event();
		$event->set('id',$idEvent);
		
		$events = $arch->restituer($event);
		
		if(count($events) ==1){
			$event = $events[0];
			if($estModerateur || $idUser == $event->get('idUser')){				
				
				$inscription = new EventInscrit();
				$inscription->set('idUser', $idInscrit);
				$inscription->set('idEvent', $idEvent);
				
				$inscritsTrouves = $arch->restituer($inscription);
				
				
				
				if(count($inscritsTrouves) ==1){
					$inscrit = $inscritsTrouves[0];
					$inscriptionModif = new EventInscrit();
					
					if($inscrit->get('etat')=='d'){
						$inscriptionModif->set('etat', 'v');
					}else if($inscrit->get('etat')=='v'){
						$inscriptionModif->set('etat', 'r');
					}else if($inscrit->get('etat')=='r'){
						$inscriptionModif->set('etat', 'd');
					}
					
					$arch->modifier($inscription, $inscriptionModif);
					
					voirEvent($vueAgenda, $idEvent, $estModerateur, $idUser);
				}
								
			}			
		}
	}
}

function pageOptions(&$vueAgenda, $idUser){
	
	$arch = new Archiviste();
	
	$user = new User();
	$user->set('id', $idUser);
	
	
	$users = $arch->restituer($user);	
	$user = $users[0];
	
	$vueAgenda->pageOptions($user);
	
	
}

function majOptions(&$vueAgenda, $idUser){
	
	$arch = new Archiviste();
	$userMAJ = new User();
	$user = new User();
	$user->set('id', $idUser);
	
	
	
	
	
	if(isset($_REQUEST['notifEvent'])){
		$userMAJ->set('notifEvent', 'x');
	}else{
		$userMAJ->set('notifEvent', 'n');
	}
	
	if(isset($_REQUEST['notifComEvent'])){
		$userMAJ->set('notifComEvent', 'x');
	}else{
		$userMAJ->set('notifComEvent', 'n');
	}
	
	$arch->modifier($user, $userMAJ); 
	$message = 'Mise a jour effectuée. <a href="/raidplanner">Retour au raidplanner</a>';
	
	
	$users = $arch->restituer($user);	
	$user = $users[0];
	
	
	$vueAgenda->pageOptions($user, $message);
	
}


function postCom(&$vueAgenda, $idEvent, $estModerateur, $idUser, $login){
	
	$texteCom = '';
	$nomEvent= '';
	$dateEvent= '0';
	
	if(isset($_POST['textCom'])){
		$texteCom = $_POST['textCom'];
	
	}
	
	if(isset($_POST['nomEvent'])){
		$nomEvent = $_POST['nomEvent'];
	
	}
	if(isset($_POST['dateEvent'])){
		$dateEvent = $_POST['dateEvent'];
	
	}
	
	if($idEvent && $texteCom){
		
		$arch=new Archiviste();
		
		$postEvent = new EventCom();
		
		$postEvent->set('idEvent', $idEvent);
		$postEvent->set('texte', $texteCom);
		$postEvent->set('login', $login);
		$postEvent->set('date', time());
		
		$arch->archiver($postEvent);
		
		mailCom($idEvent, $nomEvent, $dateEvent, $texteCom, $login);
	}
	
	
	$vueAgenda->postCommentOk($idEvent);
	
	
	
}

function mailCom($idEvent, $nomEvent, $dateEvent, $texteCom, $loginCom){
	include('core/model/Mail.php');
	
	$nomSite=Config::getVal('nom');
	$adresseSite=Config::getVal('adresse');
	$expediteur = '"'.$nomSite.'"<robot@'.$adresseSite.'>';
	$sujet = "Nouveau commentaire sur ".$nomSite;
	
	$arch = new Archiviste();
	$user = new User();
	
	$inscrit = new EventInscrit();
	$inscrit->set('idEvent', $idEvent);
	
	$inscrits = $arch->restituer($inscrit);
	
	foreach($inscrits as $inscrit){
		if($inscrit->get('etat')!='a'){
			$user->set('id', $inscrit->get('idUser'));
			$users = $arch->restituer($user);
			if(count($users)==1){
				$mail = $users[0]->get('mail');
				$notif = $users[0]->get('notifComEvent');
				$login = $users[0]->get('login');
				
				
				if($mail && $notif!='n'){
					$message = 'Bonjour '.$login.', <br />'.PHP_EOL.
					'<br />'.PHP_EOL.
					'Le commentaire suivant a été ajouté dans l\'évenement <b>'.$nomEvent.'</b> qui aura lieu le '.Agenda::timeToDate($dateEvent).' sur '.$nomSite.' : <br />'.PHP_EOL.
					'--- <br />'.PHP_EOL.
					''.$texteCom.'<br />'.PHP_EOL.
					'<i> Par '.$loginCom.'</i><br />'.PHP_EOL.
					'--- <br />'.PHP_EOL.
					'Pour y accéder, cliquez sur le lien suivant : <a href="http://'.$adresseSite.'/raidplanner/event/'.$idEvent.'"> Voir les commentaires </a><br />'.PHP_EOL.
					'<br />'.PHP_EOL.
					'<br />'.PHP_EOL.
					'Si vous ne souhaitez plus recevoir ces notifications, consultez vos <a href="http://'.$adresseSite.'/raidplanner/options">options</a>.'.PHP_EOL.
					'<br />'.PHP_EOL.
					'Ceci est un message automatique. Merci de ne pas y repondre. ';
								
				
					Mail::envoyer($mail, $expediteur, $sujet, $message);
				}
			}
		}		
	}
	
}


function mailCreation($nom, $time, $idEvent){
	include('core/model/Mail.php');
	
	$date = Agenda::timeToDate($time);
	
	$nomSite=Config::getVal('nom');
	$adresseSite=Config::getVal('adresse');
	$expediteur = '"'.$nomSite.'"<robot@'.$adresseSite.'>';

	$sujet = "Nouvel evenement sur ".$nomSite;
	
	
	$arch= new Archiviste();
	$user= new User();
	
	$users = $arch->restituer($user);
	
	foreach($users as $user){
		$mail = $user->get('mail');
		$notif = $user->get('notifEvent');
		$login = $user->get('login');
		
		if($mail && $notif!='n'){
			$message = 'Bonjour '.$login.', <br />'.PHP_EOL.
			'<br />'.PHP_EOL.
			'L\'évenement <b>'.$nom.'</b> a été ajouté sur le site '.$nomSite.'. Il aura lieu le '.$date.'<br />'.PHP_EOL.
			'<br />'.PHP_EOL.
			'Pour y accéder, cliquez sur le lien suivant : <a href="http://'.$adresseSite.'/raidplanner/event/'.$idEvent.'">'.$nom.'</a><br />'.PHP_EOL.
			'<br />'.PHP_EOL.
			'<br />'.PHP_EOL.
			'Si vous ne souhaitez plus recevoir ces notifications, consultez vos <a href="http://'.$adresseSite.'/raidplanner/options">options</a>.'.PHP_EOL.
			'<br />'.PHP_EOL.
			'Ceci est un message automatique. Merci de ne pas y repondre. ';
						
		
			Mail::envoyer($mail, $expediteur, $sujet, $message);
		}
		
	}			
}

//========MAIN=============


$vueAgenda = new VueAgenda();
$vueAgenda->setSiteName($nomSite);
 
$accesAnimateur = ['maitre','moderateur','authentif'];
$accesModerateur = ['maitre','moderateur'];
 
session_start();
$auth = new Auth();
$authBundle = $auth->checkStatut();



if($authBundle['statut']=='deco'){
	$vueAgenda->etatDeconnect();
}else if($authBundle['statut']=='connect'){
	$droits = $authBundle['droits'];
	
	$estAnimateur = in_array($droits, $accesAnimateur);
	$estModerateur = in_array($droits, $accesModerateur);	
	
	
	if(isset($param[1])){
		$action = $param[1];
                $idEvent = false;
                if (isset($param[2])){
                    $idEvent = $param[2];

                    if($action == 'event'){
                        voirEvent($vueAgenda, $idEvent, $estModerateur, $authBundle['id']);
                   
		    }else if($action == 'changeEtat' && $estAnimateur){
                        $idInscrit = false;
                        if (isset($param[3])){
                            $idInscrit = $param[3];
                        }
			changerEtatInscrit($vueAgenda, $idEvent, $estModerateur, $idInscrit, $authBundle['id']);
		
		    }else if($action == 'validInscription' ){
			inscriptionEvent($vueAgenda, $idEvent, $authBundle['id']);
		    	
		    }else if($action == 'absent' ){
			absentEvent($vueAgenda, $idEvent, $authBundle['id']);
			
		    }else if($action == 'postCom'){			
			postCom($vueAgenda, $idEvent, $estModerateur, $authBundle['id'], $authBundle['login']);
			
		    }else if($action == 'supprEvent'){			
			supprimerEvent($vueAgenda, $idEvent, $estModerateur, $authBundle['id']);
			
		    }else if($action == 'editEvent' && $estAnimateur){			
			pageEditEvent($vueAgenda, $idEvent );

		    }else if($action == 'validEditEvent' && $estAnimateur){			
			validEditEvent($vueAgenda, $idEvent, $estModerateur, $authBundle['id']);
			
		    }else if($action == 'inscription' ){
			pageInscription($vueAgenda, $idEvent);				
                    }
                }else{        			
		    if($action == 'creerEvent' && $estAnimateur){
			$vueAgenda->pageCreationRaid();
			
		    }else if($action == 'validEvent' && $estAnimateur){			
			validEvent($vueAgenda, $authBundle['id'], $authBundle['login']);
			
		    }else if($action == 'validEventWithoutMail' && $estAnimateur){
			validEvent($vueAgenda, $authBundle['id'], $authBundle['login'], false);
			
		    }else if($action == 'old' && $estAnimateur){			
			listeVieuxRaids($vueAgenda, $estAnimateur, $authBundle['id']);
			
	            }else if($action == 'options'){			
			pageOptions($vueAgenda, $authBundle['id']);
			
		    }else if($action == 'majOptions'){
			majOptions($vueAgenda, $authBundle['id']);
			
		    }else{
			listeRaids($vueAgenda, $estAnimateur, $authBundle['id']);
			
		    }
                }		
	}else{
		listeRaids($vueAgenda, $estAnimateur, $authBundle['id']);	
	}	
}else{
	$vueAgenda->etatDeconnect();
}


$head = $vueAgenda->getHead();
$body = $vueAgenda->getBody();
$scripts= $vueAgenda->getScript();

include($templatePath.'index.php');
?>
