<?php

class VueAgenda{
	private $body ='';
	private $head ='';
	private $nomSite ='';
	private $script ='';

	public function getHead(){
		return $this->head.'		
		<link rel="stylesheet" href="/mods/raidplanner/style/raidplanner-mod.css" type="text/css" media="screen"  />';	
	}
	
	public function getScript(){
		return $this->script;
	}
	
	public function getBody(){
		return '<div class="agenda">
		'.$this->body.'
		</div>';
	}
	
	
	
	public function setSiteName($siteName){
		$this->nomSite = $siteName;
	}
	

	
	
	
	
	public function etatConnect(){
		$this->head = '<title>'.$this->nomSite.' - Agenda</title>'.PHP_EOL;
		$this->body = SiteConfig::forgerBlock('Agenda','<p>bienvenue</p>');
	}
	
	public function etatDeconnect(){
		$this->head = '<title>'.$this->nomSite.' - Agenda (déconnecté)</title>'.PHP_EOL;
		$this->body = '<h1>Raidplanner</h1>
				<div class="alert alert-info text-center">Seul les <b>utilisateurs authentifiés</b> peuvent acceder a cette section.</div>
				<form method="post" action="/auth/connexion" >
					<div class="form-group row justify-content-center">
						<label class="col-form-label col-2" for="login" >Login : </label>
						<div class="col-5">
							<input type="text" class="form-control" id="login" name="login" />
						</div>
					</div>
					<div class="form-group row justify-content-center">
						<label class="col-form-label col-2" for="pass" >Password : </label>
						<div class="col-5">
							<input type="password" class="form-control" id="pass" name="pass" />
						</div>
					</div>
					<div class="form-group d-flex justify-content-center">						
							<input type="submit" class="btn btn-primary" value="Connexion" id="envoi" />
					</div>	
					<div class="form-group d-flex justify-content-center">						
							<a class="btn btn-outline-primary" href="/auth/creation"> S\'enregistrer</a>
					</div>					
				</form>
				';
	}
	
	public function etatNonDroit(){
		$this->head = '<title>'.$this->nomSite.' - Agenda</title>'.PHP_EOL;
		$this->body ='<p style="text-align:center;">Vous ne possedez pas les droits pour acceder a cette page. Contacter l\'administrateur si vous souhaitez les obtenir.</p>';
		
	}
	
	public function panneauCreerRaid(){
		$this->body .= '<div class="bottomEventPannel"><a href="/raidplanner/creerEvent">Creer un nouvel évenement</a> </div>';
	}
	
	public function panneauVoirRaidsActuels(){
		$this->body .= '
		<div class="bottomEventPannel"><a href="/raidplanner">Voir les évenement actuels</a> </div>';
	}
	
	public function panneauVoirRaidsAnciens(){
			$this->body .= '
			<div class="bottomEventPannel"><a href="/raidplanner/old">Voir les évenement anciens</a> </div>';
	}
	
	public function userPannel(){
		$this->body .= '
			<div class="agendaUserPannel">[<a href="/raidplanner/options" >options</a>] [<a href="/auth/profil">compte</a>] [<a href="/auth/deconnexion">Deconnexion</a>]</div>';
		
	}
	
	
	public function listerRaid($listeEvents){
		
		
	
		$this->head = '<title>'.$this->nomSite.' - Evenements </title>'.PHP_EOL;
		
		$html = '';
		foreach($listeEvents as $event){
			
			$duree = '';
			if($event->get('duree')){
				$duree = 'pendant '.$event->get('duree');
			}
			
			$html.='<div class="etatEvent '.$event->get('monEtat').'">
			<a href="/raidplanner/event/'.$event->get('id').'" class="nomEvent" >'.$event->get('nom').'</a> <br />
			<div class="infoEvent">
				<b>Quand</b> : '.Agenda::timeToDate($event->get('date')).' '.$duree.'<br />
				<b>Raid lead</b> : '.$event->get('nomLead').'<br />
				<b>Inscriptions </b>: '.$event->get('nbValid').' validés,  '.$event->get('nbDispo').' en attente.
			</div>
			</div>';
			
		}
		
		$this->body .= ' <h1> Liste des Raids </h1>
		'.$html;
	}
	
	public function pageCreationRaid(){
		$this->head = '<title>'.$this->nomSite.' - Creer un évenement </title>'.PHP_EOL;
		
		$this->body .= '<p>Création d\'un évenement</p>'.$this->craftFormEvent();
		
		$this->chargerRaidplannerJS();
		
	}
	
	public function pageEditEvent($event){
		$this->head = '<title>'.$this->nomSite.' - Editer un évenement </title>'.PHP_EOL;		
		
		$this->body .= '<p>Edition de l\'evenement.</p>
		'.$this->craftFormEvent($event->get('nom'), $event->get('duree'), Agenda::timeToDay($event->get('date')), Agenda::timeToHour($event->get('date')), $event->get('texte'), $event->get('id'));
	}
	
	public function pageEventEditOk($event){
		$this->head = '<title>'.$this->nomSite.' - Editer un évenement </title>'.PHP_EOL;		
		
		$this->body .= '<p>Evenement édité.  <a href="/raidplanner/event/'.$event->get('id').'">Retour à l\'évenement</a></p>';
		
		$this->script = '<script type="text/javascript" > $(document).ready(function(){document.location.href="/raidplanner/event/'.$event->get('id').'"; });</script>';
	}
	
	public function erreurValidEvent($nom, $duree, $date, $heure, $texte){
	
		$this->head = '<title>'.$this->nomSite.' - Creer un évenement </title>'.PHP_EOL;
		
		$this->body .= '<p>Création d\'un évenement</p>
						<div class="alert alert-warning" >Une erreur est survenue, verifiez bien tous les champs</div>'.$this->craftFormEvent($nom, $duree, $date, $heure, $texte);
	}
	
	public function eventValidOk($idEvent){
		$this->head = '<title>'.$this->nomSite.' - Creer un évenement </title>'.PHP_EOL;
		
		$this->body .= '<div class="alert alert-success" role="alert">Evenement créé avec succes</div>
		<div><a href="/raidplanner/event/'.$idEvent.'"> Voir l\'évenement </a> - <a href="/raidplanner"> Retour à la liste des evenements </a></div>
		<input type="hidden" id="idNewEvent" idEvent="'.$idEvent.'" />';
		
		
		$this->chargerRaidplannerJS();
		
	}
	
	public function ouvrirEvent($event, $editable, $inscriptions, $inscritSoiMeme, $commentaires){
		$this->head = '<title>'.$this->nomSite.' - '.$event->get('nom').' </title>'.PHP_EOL;
		
		
		$duree = '';
		if($event->get('duree')){
			$duree = 'pendant '.$event->get('duree');
		}		
		
		$edition = '';
		if($editable){
			$edition=' [<a href="/raidplanner/supprEvent/'.$event->get('id').'">Supprimer</a>] [<a href="/raidplanner/editEvent/'.$event->get('id').'">Editer</a>]';
			
		}
		
		$optionsInscritSoi= '';
		if($inscritSoiMeme && $inscritSoiMeme=='a'){
			$optionsInscritSoi= '<b>Mon statut</b> : Absent [<a href="/raidplanner/inscription/'.$event->get('id').'">Disponible</a>]';
			
		}else if($inscritSoiMeme){
			$optionsInscritSoi= '<b>Mon statut</b> : Disponible  [<a href="/raidplanner/absent/'.$event->get('id').'">Absent</a>]';
		}else{
			$optionsInscritSoi = '<b>Mon statut</b> : Non Inscrit [<a href="/raidplanner/inscription/'.$event->get('id').'">Disponible</a>] [<a href="/raidplanner/absent/'.$event->get('id').'">Absent</a>]';
		}
		
		
		$listeDispos = '';
		$listeAbsents = '';
		
		$nbDispo =0;
		$nbValide=0;
		$nbRefuse=0;
		
		foreach($inscriptions as $inscrit){
		
			if($inscrit->get('etat')=='a'){
				$listeAbsents.= '<div class="agendaEtat'.$inscrit->get('etat').'">'.$inscrit->get('login').'</div>';
			}else{
				if($editable){
					$listeDispos.= '<div > <a href="/raidplanner/changeEtat/'.$inscrit->get('idEvent').'/'.$inscrit->get('idUser').'" class="agendaEtat'.$inscrit->get('etat').'">'.$inscrit->get('login').' ('.$inscrit->get('classe').')</a></div>';
				}else{
					$listeDispos.= '<div > <span class="agendaEtat'.$inscrit->get('etat').'">'.$inscrit->get('login').' ('.$inscrit->get('classe').')</span></div>';
				}
				
				if($inscrit->get('etat')=='v'){
					$nbValide++;
				}else if($inscrit->get('etat')=='r'){
					$nbRefuse++;
				}else if($inscrit->get('etat')=='d'){
					$nbDispo++;
				}
			}
			
		}
		
		
		//comentaires
		
		$panneauCom = $this->panneauCom($commentaires, $event);
		
		
		$this->body .= '
			
			<div class="agendaZoneEditEvent"> '.$edition.' [<a href="/raidplanner">Retour</a>]<br /></div>
			<div class="row">
				<div class="ZoneInfosEvent col-sm-8">
					<div>
						<div class="detailEventNom">'.$event->get('nom').'</div>
						<div class="infoEvent">
							<b>Quand</b> : Le '.Agenda::timeToDate($event->get('date')).' '.$duree.' <br />
							<b>Raid lead</b> : '.$event->get('nomLead').'<br />
							<b>Inscription</b> : <span class="agendaEtatv">'.$nbValide.' Validés</span> , <span class="agendaEtatd">'.$nbDispo.' En Attente</span> , <span class="agendaEtatr">'.$nbRefuse.' Refusés</span><br /><br /><br />
						</div>					
						<div>'.$event->get('texte').'</div>
						<hr />
					</div>			
					<div>
						<p>Disponibles :</p>
						'.$listeDispos.'
						<hr />
					</div>
					<div>
						<p>Absents :</p>
						'.$listeAbsents.'
						<hr />
					</div>
					<div>
					'.$optionsInscritSoi.'
					</div>
				</div>
				'.$panneauCom.'
			</div>
			';
		
		
		$this->chargerRaidplannerJS();
	}
	
	public function pageSuppressionEvent(){
		$this->head = '<title>'.$this->nomSite.' - Evenement supprimé </title>'.PHP_EOL;
		
		$this->body .= '<div class="alert alert-success" role="alert">Evenement supprimé avec succes. <a href="/raidplanner"> Retour à la liste des evenements.</a>
		 ou <a href="/raidplanner/old"> Retour à la liste des evenements anciens.</a></div>';

		
		
	}
	
	public function pageInscription($idEvent){
		$this->head = '<title>'.$this->nomSite.' - Inscription à un évenement </title>'.PHP_EOL;
		
		$this->body .= '<br />
					<form method="post" class="form-horizontal" action="/raidplanner/validInscription/'.$idEvent.'" >
						 <div class="form-group">
						 	<label for="classe" class="col-sm-3 control-label">Votre role :</label>
							<div class="col-sm-4">
								<input class="form-control" id="classe" type="text" name="classe" />	
							</div>
							 <div class="col-sm-1">
								<input type="submit" class="btn btn-primary" value="Valider" />
							</div>												
						</div>
					</form>
		';
	}
	
	public function pageinscriptionOk($idEvent){
		$this->head = '<title>'.$this->nomSite.' - Inscription à un évenement </title>'.PHP_EOL;
		
		$this->body .= '<p>Inscription prise en compte <p>
		<p> <a href="/raidplanner/event/'.$idEvent.'">Retour à l\'evenement</a> <p>
		';
		$this->script = '<script type="text/javascript" > $(document).ready(function(){document.location.href="/raidplanner/event/'.$idEvent.'"; });</script>';
	}
	
	public function pageAbsentOk($idEvent){
		$this->head = '<title>'.$this->nomSite.' - Inscription à un évenement </title>'.PHP_EOL;
		
		$this->body .= '<p>Absence prise en compte <p>
		<p> <a href="/raidplanner/event/'.$idEvent.'">Retour à l\'evenement</a><p>
		';
		
		$this->script = '<script type="text/javascript" > $(document).ready(function(){document.location.href="/raidplanner/event/'.$idEvent.'"; });</script>';
	}
	
	public function postCommentOk($idEvent){
		$this->head = '<title>'.$this->nomSite.' - Poster un commentaire</title>'.PHP_EOL;
		
		$this->body .= '<p>Commentaire enregistré. <p>
		<p> <a href="/raidplanner/event/'.$idEvent.'">Retour à l\'evenement</a><p>
		';
		
		$this->script = '<script type="text/javascript" > $(document).ready(function(){document.location.href="/raidplanner/event/'.$idEvent.'"; });</script>';
	}
	
	
	public function pageOptions($user, $message=''){
		
		$this->head = '<title>'.$this->nomSite.' - Options du raidplanner </title>'.PHP_EOL;
		
		
		
		if($message){
			$message='<div class="alert alert-success" role="alert">'.$message.'</div>';
		}
		
		$notifEvent = $user->get('notifEvent');
		if($notifEvent && $notifEvent =='n'){
			$notifEvent = false;
		}else{
			$notifEvent = true;
		}
		
		$notifComEvent = $user->get('notifComEvent');
		if($notifComEvent && $notifComEvent =='n'){
			$notifComEvent = false;
		}else{
			$notifComEvent = true;
		}
		
		$html = $this->craftFormOptions($notifEvent, $notifComEvent);
		
		$this->body = SiteConfig::forgerBlock('Options', $message.$html);
		
	}
	
	
	//private zone
	private function panneauCom($commentaires, $event){
		$html= '<div class="zoneComEvent col-sm-4">
			<h2>Commentaires</h2>';
		
		foreach($commentaires as $com){
			$html .= '
			<div class="petitCom">
				<div>
					'.$com->get('texte').'
				</div>
				<div class="petitComDate">
					'.$com->get('login').' le '.Agenda::timeToDate($com->get('date')).'
				</div>
			</div>';			
		}
		
		$html .= '
			<form method="post" action="/raidplanner/postCom/'.$event->get('id').'">
				<input type="hidden" name="nomEvent" value="'.$event->get('nom').'" />
				<input type="hidden" name="dateEvent" value="'.$event->get('date').'" />
				<div class="form-group">
					<textarea class="form-control" name="textCom" ></textarea>
				</div>
				<div class="form-group">
					<input type="submit" value="Poster" class="btn btn-primary" />
				</div>
			</form>
		</div>';
		
		
		return $html;
		
		
		
	}
	
	
	private function craftFormEvent($nomEvent ='', $dureeEvent='', $jourEvent = '', $heureEvent = '', $textEvent='', $idEvent = false){
		$params ='';
		$retourVal = '';
		$newEvent='';
		if($idEvent){
			$params = 'validEditEvent/'.$idEvent;
			$retourVal = '<a href="/raidplanner/event/'.$idEvent.'" class="btn btn-primary">Retour</a>';
		}else{
			$newEvent='id="formNewEvent"';
			$params = 'validEvent';
			$retourVal = '<a href="/raidplanner" class="btn btn-primary" >Retour</a>';
		}
		
		
		$form = '<form class="form-horizontal" method="post" '.$newEvent.' action="/raidplanner/'.$params.'"> 
				<div class="form-group">
					<label class="control-label col-sm-4" for="nomEvent">Nom de l\'evenement :</label>
					<div class="col-sm-5">
						<input class="form-control" id="nomEvent" type="text" name="nomEvent" required placeholder="Nom" value="'.$nomEvent.'" />
					</div>
				</div>
				<div class="form-group">
					<label class="control-label col-sm-4" for="dateEvent">Jour :</label>
					<div class="col-sm-5">
						<input class="form-control" type="date" id="dateEvent" name="dateEvent" required placeholder="jj-mm-aaaa" value="'.$jourEvent.'" />
					</div>
				</div>
				<div class="form-group">
					<label class="control-label col-sm-4" for="heureEvent">Heure :</label>
					<div class="col-sm-5">
						<input class="form-control" type="time" id="heureEvent" name="heureEvent" required placeholder="hh:mm" value="'.$heureEvent.'" />
					</div>
				</div>
				<div class="form-group">
					<label class="control-label col-sm-4" for="dureeEvent">Durée :</label>
					<div class="col-sm-5">
						<input class="form-control" type="text" id="dureeEvent" name="dureeEvent" required placeholder="x minutes/heures" value="'.$dureeEvent.'" />
					</div>
				</div>
				<div class="form-group">
					Description : <br />
					<textarea id="ckeTextEvent" name="textEvent">'.$textEvent.'</textarea>	
				</div>
				<div class="form-group">
				 '.$retourVal.' <input type="submit" value="Valider" class="btn btn-primary" />
				</div>
			</form>';
		
			
		$this->addCkeLibs();
		
		return $form;
	}
	
	
	
	private function craftFormOptions( $notifsEvent = true, $notifsComEvent = true){
	
		
		$eventCheck='';
		$comCheck='';
		
		
		if($notifsEvent){
			$eventCheck= 'checked ';
		}
		if($notifsComEvent){
			$comCheck= 'checked ';
		}
		
		$html ='
		<form method="post" action="/raidplanner/majOptions" >
			<div class="form">
				<fieldset>
						<legend>Vos notifications</legend>			
						<div>			
							<p>Cochez les notification que vous souhaitez recevoir par e-mail:<br /></p>
							<input type="checkbox" id="notifEvent" name="notifEvent" '.$eventCheck.'/> <label for="notifEvent">Nouvel évenement</label><br />
							<input type="checkbox" id="notifComEvent" name="notifComEvent" '.$comCheck.'/> <label for="notifComEvent">Nouveau commentaire</label><br />
						</div>
				</fieldset>
				<div>
					<input type="submit" class="btn btn-primary" value="Enregistrer" />
				</div>		
			</div>
			</form>';
			
			return $html;
			
	}
	
	
	private function addCkeLibs(){
		
		$this->script.='<script type="text/javascript" src="/tools/jquery-migrate.min.js"></script>
		<script type="text/javascript" src="/tools/jquery-ui/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/tools/elfinder/js/elfinder.min.js"></script>
		<script type="text/javascript" src="/tools/elfinder/js/i18n/elfinder.fr.js"></script>
		<script type="text/javascript" src="/tools/ckeditor/ckeditor.js"></script>
		<script type="text/javascript" > $(document).ready(function(){CKEDITOR.replace( \'ckeTextEvent\');});</script>		
		';
		
		$this->head.='<link rel="stylesheet" href="/tools/jquery-ui/jquery-ui.theme.min.css" type="text/css" media="screen" >
		<link rel="stylesheet" href="/tools/jquery-ui/jquery-ui.min.css" type="text/css" media="screen" >
		<link rel="stylesheet" href="/tools/elfinder/css/elfinder.min.css" type="text/css" media="screen"  />
		';
	}
	
	
	private function chargerRaidplannerJS(){
		$this->script.='<script type="text/javascript" src="/mods/raidplanner/view/plasmideRaidplanner.js"></script>
		';
		
	}
	
	
}


?>
